/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.audit.script;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jwall.audit.Event;
import org.jwall.audit.EventView;
import org.jwall.audit.script.ScriptEvent;
import org.jwall.audit.script.utils.ListIteratorImpl;
import org.jwall.web.audit.filter.FilterExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventList<E extends Event>
extends AbstractList<ScriptEvent> {
    static Logger log = LoggerFactory.getLogger(EventList.class);
    EventView<E> view;
    FilterExpression filter;
    int size = 0;

    public EventList(EventView<E> view, FilterExpression filter) {
        log.debug("Creating new lazy-list based on view {} and filter {}", view, (Object)filter);
        this.view = view;
        this.filter = filter;
        try {
            this.size = view.count(filter).intValue();
            log.debug("list has {} elements", (Object)this.size);
        }
        catch (Exception e) {
            log.error("failed to check list size: {}", (Object)e.getMessage());
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            this.size = 0;
        }
    }

    @Override
    public void clear() {
        log.debug("clearing list...");
        this.size = 0;
    }

    @Override
    public ScriptEvent get(int idx) {
        ScriptEvent evt;
        block5: {
            log.debug("lazy-list.get( {} )   list size is: {}", (Object)idx, (Object)this.size);
            evt = null;
            if (idx >= 0 && idx < this.size) {
                try {
                    Long curSize = this.view.count(this.filter);
                    log.info("curSize: {},  size: {}", (Object)curSize, (Object)this.size);
                    List<E> list = this.view.list(this.filter, idx, 1);
                    log.debug("view.list( {}, {}, 1 )", (Object)this.filter, (Object)idx);
                    if (list != null && !list.isEmpty()) {
                        evt = new ScriptEvent((Event)list.get(0));
                    }
                    break block5;
                }
                catch (Exception e) {
                    log.error("failed to retrieve event list[{}]: {}", (Object)idx, (Object)e.getMessage());
                    if (log.isDebugEnabled()) {
                        e.printStackTrace();
                    }
                    break block5;
                }
            }
            log.debug("index outputWriter of bounds!");
        }
        log.debug("returning event({}) = {}", (Object)idx, evt);
        return evt;
    }

    @Override
    public boolean isEmpty() {
        return this.size <= 0;
    }

    @Override
    public Iterator<ScriptEvent> iterator() {
        log.debug("returning new iterator()");
        return new ListIteratorImpl(this);
    }

    @Override
    public int lastIndexOf(Object arg0) {
        return -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ListIterator<ScriptEvent> listIterator() {
        log.debug("returning new listIterator()");
        return new ListIteratorImpl(this);
    }

    @Override
    public ListIterator<ScriptEvent> listIterator(int arg0) {
        log.debug("returning new listIterator( {} )", (Object)arg0);
        return new ListIteratorImpl(this, arg0);
    }
}

