/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.audit.script.utils;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class TimePrintStream
extends PrintStream {
    boolean sol = true;

    public TimePrintStream(OutputStream out) {
        super(out);
    }

    public TimePrintStream(File file) throws IOException {
        super(file);
    }

    @Override
    public void print(Object obj) {
        if (this.sol) {
            this.printTime();
        }
        super.print(obj);
    }

    @Override
    public void print(String s) {
        if (this.sol) {
            this.printTime();
        }
        super.print(s);
        this.sol = false;
    }

    @Override
    public void println() {
        super.println();
        this.sol = true;
    }

    @Override
    public void println(Object x) {
        this.printTime();
        super.println(x);
    }

    @Override
    public void println(String x) {
        this.printTime();
        super.println(x);
    }

    protected void printTime() {
        super.print("@");
        super.print(System.currentTimeMillis());
        super.print(": ");
    }

    @Override
    public void write(int b) {
        if (this.sol) {
            this.sol = false;
            this.printTime();
        }
        super.write(b);
        this.sol = b == 10;
    }
}

