/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.net;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jwall.AuditServer;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventListener;
import org.jwall.web.audit.filter.AuditEventFilter;
import org.jwall.web.audit.net.NetworkEventServer;
import org.jwall.web.audit.util.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkClientWorkerThread
extends Thread
implements AuditEventListener {
    public static final int MAX_LOGIN_FAILURES = 3;
    private static Logger log = LoggerFactory.getLogger((String)"NetworkClientWorkerThread");
    ObjectOutputStream out;
    BufferedReader in;
    boolean closed = false;
    BlockingQueue<AuditEvent> events;
    int sent = 0;
    String id = "";
    Socket sock;
    AuditEventFilter filter = null;
    Authenticator users = null;
    static boolean debug = false;
    NetworkEventServer server;

    public NetworkClientWorkerThread(Socket sock, Authenticator users, NetworkEventServer serv) throws Exception {
        log.debug("Creating new NetworkClientWorkerThread for " + sock);
        this.server = serv;
        this.users = users;
        this.id = "Client[" + sock.getInetAddress().getHostAddress() + ":" + sock.getPort() + "]";
        this.events = new LinkedBlockingQueue<AuditEvent>();
        this.sock = sock;
        this.closed = false;
    }

    private void authenticate() throws Exception {
        AuditServer.log("Incoming connection: " + this);
        this.out = new ObjectOutputStream(this.sock.getOutputStream());
        this.in = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
        boolean authOk = false;
        String login = "";
        int tries = 0;
        while (!authOk && tries++ < 3) {
            this.out.writeObject("LOGIN");
            login = this.in.readLine();
            this.out.writeObject("PASSWORD");
            String pass = this.in.readLine();
            authOk = this.users.authenticate(login, pass);
            if (authOk) continue;
            this.out.writeObject("LOGIN FAILED!");
            AuditServer.log(this + " Login failed for user \"" + login + "\"");
        }
        if (!authOk) {
            this.out.writeObject("ERROR: Maximum number of login attempts exceeded!");
            throw new Exception("Authentication error: Number of login attempts exceeded!");
        }
        this.out.writeObject("LOGIN OK");
        AuditServer.log(this + " User " + login + " authenticated successfully.");
    }

    @Override
    public void run() {
        try {
            this.authenticate();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.closed = true;
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!NetworkClientWorkerThread.this.closed) {
                    NetworkClientWorkerThread.this.checkCommand();
                }
            }
        });
        t.start();
        try {
            while (!this.closed) {
                this.pushEvents();
            }
            AuditServer.log(this + " client disconnecting.");
            this.sock.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.server.unregisterClient(this);
    }

    private void pushEvents() throws Exception {
        try {
            while (this.events.isEmpty()) {
                Thread.sleep(128L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.sock.isInputShutdown() || this.sock.isOutputShutdown() || !this.sock.isConnected() || this.sock.isClosed()) {
            this.sock.close();
            this.closed = true;
        }
        while (!this.events.isEmpty()) {
            log.debug("NetworkClientWorker: sending event..");
            AuditEvent e = this.events.take();
            this.out.writeObject(e);
            ++this.sent;
        }
    }

    @Override
    public void eventArrived(AuditEvent evt) {
        if (this.sock.isOutputShutdown()) {
            this.events.clear();
            this.closed = true;
        }
        if (this.filter == null || this.filter.matches(evt)) {
            this.events.add(evt);
        }
    }

    @Override
    public void eventsArrived(Collection<AuditEvent> events) {
        for (AuditEvent evt : events) {
            this.eventArrived(evt);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public String toString() {
        return this.id;
    }

    public void checkCommand() {
        block7: {
            try {
                String cmd = null;
                while (cmd == null) {
                    cmd = this.in.readLine();
                    Thread.sleep(128L);
                }
                if ("DISCONNECT".equals(cmd)) {
                    this.closed = true;
                }
                if (cmd == null || !cmd.startsWith("SET_FILTER")) break block7;
                try {
                    String[] t = cmd.split(" ");
                    if ("null".equals(t[1])) {
                        this.filter = null;
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.filter = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void finalize() {
        this.closed = true;
    }
}

