/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit;

import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONObject;
import org.jwall.audit.EventProcessor;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventMessage;
import org.jwall.web.audit.io.ModSecurity2AuditReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.Processor;
import stream.data.DataFactory;
import stream.util.KeyFilter;

public class GELFSender
implements EventProcessor<AuditEvent>,
Processor {
    static Logger log = LoggerFactory.getLogger(GELFSender.class);
    String prefix = "_rule:";
    String key = "event";
    String[] keys = null;
    String address;
    Integer port;
    Socket socket;
    PrintStream out;

    protected void connect() throws Exception {
        log.debug("Opening socket connection to {}:{}... ", (Object)this.address, (Object)this.port);
        try {
            this.socket = new Socket(this.address, (int)this.port);
            this.out = new PrintStream(this.socket.getOutputStream());
        }
        catch (Exception e) {
            this.socket = null;
            throw e;
        }
    }

    public Data process(Data input) {
        block3: {
            Serializable value = (Serializable)input.get((Object)this.key);
            if (value != null && value instanceof AuditEvent) {
                AuditEvent evt = (AuditEvent)value;
                try {
                    evt = this.processEvent(evt, (Map<String, Object>)new HashMap<String, Object>());
                    input.put((Object)this.key, (Object)evt);
                }
                catch (Exception e) {
                    log.error("Failed to process item: {}", (Object)e.getMessage());
                    if (!log.isDebugEnabled()) break block3;
                    e.printStackTrace();
                }
            }
        }
        return input;
    }

    @Override
    public AuditEvent processEvent(AuditEvent evt, Map<String, Object> context) throws Exception {
        String txId = evt.get("TX_ID");
        Long timestamp = evt.getTimestamp();
        AuditEventMessage[] msgs = evt.getEventMessages();
        for (int i = 0; i < msgs.length; ++i) {
            List<String> tags;
            AuditEventMessage msg = msgs[i];
            Data item = DataFactory.create();
            item.put((Object)"version", (Object)"1.0");
            item.put((Object)"host", (Object)evt.get("REQUEST_HEADERS:Host"));
            item.put((Object)"short_message", (Object)msg.getRuleMsg());
            item.put((Object)"full_message", (Object)msg.getRuleMsg());
            item.put((Object)"timestamp", (Object)(timestamp.doubleValue() / 1000.0));
            item.put((Object)"level", (Object)msg.getSeverity());
            item.put((Object)"facility", (Object)("ModSecurity:" + evt.get("SENSOR_NAME")));
            item.put((Object)"file", (Object)msg.getFile());
            item.put((Object)"line", (Object)msg.getLine());
            item.put((Object)"_event:txId", (Object)txId);
            String ruleId = msg.getRuleId();
            if (ruleId != null) {
                item.put((Object)(this.prefix + "id"), (Object)msg.getRuleId());
            }
            if ((tags = msg.getRuleTags()) != null && !tags.isEmpty()) {
                item.put((Object)(this.prefix + "tags"), (Object)this.join(msg.getRuleTags()));
            }
            log.debug("Emitting item {} to {}", (Object)item, (Object)this.address);
            this.emit(item);
        }
        return null;
    }

    protected void emit(Data input) {
        block6: {
            try {
                String json;
                if (this.socket == null) {
                    log.debug("Socket not connected, trying to connect...");
                    this.connect();
                }
                if (this.keys != null) {
                    Set selected = KeyFilter.select((Data)input, (String[])this.keys);
                    Data item = DataFactory.create();
                    for (String k : selected) {
                        item.put((Object)k, input.get((Object)k));
                    }
                    log.debug("Sending item {}", (Object)item);
                    json = JSONObject.toJSONString((Map)item);
                } else {
                    json = JSONObject.toJSONString((Map)input);
                }
                this.out.println(json);
            }
            catch (Exception e) {
                log.error("Faild to send item: {}", (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block6;
                e.printStackTrace();
            }
        }
    }

    public void finish() throws Exception {
        if (this.out != null) {
            this.out.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public String join(List<String> strs) {
        StringBuffer s = new StringBuffer();
        if (strs == null || strs.isEmpty()) {
            return s.toString();
        }
        Iterator<String> it = strs.iterator();
        while (it.hasNext()) {
            s.append(it.next());
            if (!it.hasNext()) continue;
            s.append(",");
        }
        return s.toString();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public static void main(String[] args) throws Exception {
        ModSecurity2AuditReader reader = new ModSecurity2AuditReader(new File("/Users/chris/audit/jwall-audit.log"));
        AuditEvent evt = reader.readNext();
        GELFSender sender = new GELFSender();
        sender.setAddress("127.0.0.1");
        sender.setPort(9105);
        sender.processEvent(evt, (Map<String, Object>)new HashMap<String, Object>());
    }
}

