/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.net;

import java.net.ServerSocket;
import java.net.Socket;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventListener;
import org.jwall.web.audit.io.AuditEventReader;
import org.jwall.web.audit.io.ModSecurity2AuditReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditEventSocketReceiver
extends Thread {
    static Logger log = LoggerFactory.getLogger(AuditEventSocketReceiver.class);
    ServerSocket socket;
    AuditEventListener listener;

    public AuditEventSocketReceiver(int port) throws Exception {
        this.socket = new ServerSocket(port);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Socket client = this.socket.accept();
                    AuditEventReaderThread handler = new AuditEventReaderThread(client);
                    log.info("Starting new handler for incoming connection from {}:{}", (Object)client.getInetAddress().getHostAddress(), (Object)client.getPort());
                    handler.start();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public class AuditEventReaderThread
    extends Thread {
        AuditEventReader reader;
        Socket socket;

        public AuditEventReaderThread(Socket sock) throws Exception {
            this.socket = sock;
            this.reader = new ModSecurity2AuditReader(sock.getInputStream());
        }

        @Override
        public void run() {
            try {
                AuditEvent evt = this.reader.readNext();
                while (evt != null) {
                    if (AuditEventSocketReceiver.this.listener != null) {
                        AuditEventSocketReceiver.this.listener.eventArrived(evt);
                    }
                    evt = this.reader.readNext();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            log.info("Handler for connection {}:{} exiting...", (Object)this.socket.getInetAddress(), (Object)this.socket.getPort());
        }
    }
}

