/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.net;

import java.io.InputStream;
import java.net.Socket;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jwall.web.audit.net.NetworkAuditEventSource;

public class SSLNetworkAuditEventSource
extends NetworkAuditEventSource {
    private SSLNetworkAuditEventSource(Socket s) throws Exception {
        super(s);
    }

    public static SSLNetworkAuditEventSource createSSLSource(InputStream keyStoreFile, String pass, String server, int port) throws Exception {
        char[] passphrase = pass.toCharArray();
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(keyStoreFile, passphrase);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(keystore);
        SSLContext context = SSLContext.getInstance("TLS");
        TrustManager[] trustManagers = tmf.getTrustManagers();
        context.init(null, trustManagers, null);
        SSLSocketFactory sf = context.getSocketFactory();
        return new SSLNetworkAuditEventSource(sf.createSocket(server, port));
    }
}

