/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.processor;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jwall.audit.EventProcessor;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.ModSecurity;
import org.jwall.web.audit.rules.PersistentCollectionExtractor;
import stream.Data;
import stream.Processor;
import stream.annotations.Parameter;

public class PersistentCollectionProcessor
extends PersistentCollectionExtractor
implements Processor,
EventProcessor<AuditEvent> {
    String key = ModSecurity.SECTION_NAMES[10];

    public String getKey() {
        return this.key;
    }

    @Parameter
    public void setKey(String key) {
        this.key = key;
    }

    public Data process(Data data) {
        if (data == null) {
            return data;
        }
        Serializable ruleLog = (Serializable)data.get((Object)this.key);
        if (ruleLog != null) {
            Map<String, String> coll = PersistentCollectionProcessor.processRuleLog(ruleLog.toString(), new HashMap<String, String>());
            data.putAll(coll);
        }
        return data;
    }

    @Override
    public AuditEvent processEvent(AuditEvent event, Map<String, Object> context) throws Exception {
        Map<String, String> coll = new HashMap<String, String>();
        for (String key : context.keySet()) {
            coll.put(key, context.get(key).toString());
        }
        coll = PersistentCollectionProcessor.extractScores(event, coll);
        for (String key : coll.keySet()) {
            event.set(key, coll.get(key));
        }
        return event;
    }
}

