/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.util;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class Cache<V> {
    int size;
    Map<String, V> data = new HashMap<String, V>();
    LinkedList<String> keys = new LinkedList();
    long hits = 0L;
    long misses = 0L;

    public Cache(int size) {
        this.size = size;
        this.keys = new LinkedList();
    }

    public void put(String key, V object) {
        this.data.put(key, object);
        this.keys.add(key);
        if (this.keys.size() > this.size) {
            this.prune();
        }
    }

    public boolean containsKey(String key) {
        boolean b = this.data.containsKey(key);
        if (b) {
            ++this.hits;
        } else {
            ++this.misses;
        }
        return b;
    }

    public V get(String key) {
        V dat = this.data.get(key);
        return dat;
    }

    public void prune() {
        while (this.keys.size() > this.size) {
            String key = this.keys.removeFirst();
            this.data.remove(key);
        }
    }

    public int size() {
        return this.keys.size();
    }

    public int maximumSize() {
        return this.size;
    }

    public boolean isFull() {
        return this.keys.size() >= this.size;
    }

    public Long getHits() {
        return this.hits;
    }

    public Long getMisses() {
        return this.misses;
    }

    public Double getUse() {
        return new Double(this.keys.size()) / new Double(this.size);
    }
}

