/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.util;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;
import stream.ProcessContext;
import stream.annotations.Parameter;

public class Timestamp
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(Timestamp.class);
    SimpleDateFormat dateFormat = null;
    String key = "@timestamp";
    String format = null;
    String from = null;

    public Timestamp() {
    }

    public Timestamp(String key, String format, String from) {
        this.setKey(key);
        this.setFormat(format);
        this.setFrom(from);
    }

    public String getKey() {
        return this.key;
    }

    @Parameter
    public void setKey(String key) {
        this.key = key;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public Data process(Data data) {
        if (data != null && this.key != null) {
            Serializable from = (Serializable)data.get((Object)this.getFrom());
            if (this.dateFormat != null && from != null) {
                try {
                    Date date = this.dateFormat.parse(from.toString());
                    data.put((Object)this.key, (Object)date.getTime());
                }
                catch (Exception e) {
                    log.error("Failed to parse timestamp from '{}', expected format is '{}'", (Object)from, (Object)this.format);
                }
            } else {
                data.put((Object)this.key, (Object)new Long(System.currentTimeMillis()));
            }
        }
        return data;
    }

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        if (this.getFormat() != null && this.getFrom() != null) {
            this.dateFormat = new SimpleDateFormat(this.getFormat());
        }
    }
}

