/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.audit;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jwall.audit.EventProcessor;
import org.jwall.web.audit.AuditEventProcessorPipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import stream.runtime.setup.factory.ObjectFactory;

public class EventProcessorFinder {
    static Logger log = LoggerFactory.getLogger(EventProcessorFinder.class);

    public void deployCustomEventProcessors(File procDefs, AuditEventProcessorPipeline pipeline) throws Exception {
        this.deployCustomEventProcessors(new FileInputStream(procDefs), pipeline);
    }

    public void deployCustomEventProcessors(InputStream processorDefinitions, AuditEventProcessorPipeline pipeline) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(processorDefinitions);
        Element root = doc.getDocumentElement();
        this.deployEventProcessors(root.getElementsByTagName("Processor"), pipeline);
        this.deployEventProcessors(root.getElementsByTagName("processor"), pipeline);
    }

    protected void deployEventProcessors(NodeList candidateNodes, AuditEventProcessorPipeline pipeline) {
        if (candidateNodes == null || candidateNodes.getLength() == 0) {
            log.debug("List of candidateNodes is empty: {}", (Object)candidateNodes);
            return;
        }
        ObjectFactory of = ObjectFactory.newInstance();
        for (int i = 0; i < candidateNodes.getLength(); ++i) {
            Node node = candidateNodes.item(i);
            if (node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("processor")) {
                try {
                    Map params = of.getAttributes(node);
                    Double priority = new Double(1000.0);
                    if (params.get("priority") != null) {
                        priority = new Double((String)params.get("priority"));
                    }
                    log.info("Found priority {}", (Object)priority);
                    Object o = of.create((Element)node);
                    if (!(o instanceof EventProcessor)) continue;
                    EventProcessor eventProcessor = (EventProcessor)o;
                    log.info("Registering AuditEventProcessor {} with priority {}", (Object)eventProcessor, (Object)priority);
                    pipeline.register(priority, eventProcessor);
                }
                catch (Exception e) {
                    log.error("Failed to register processor: {}", (Object)e.getMessage());
                    if (!log.isDebugEnabled()) continue;
                    e.printStackTrace();
                }
                continue;
            }
            log.warn("Skipping node {}", (Object)node.getNodeName());
        }
    }
}

