/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.log.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.util.WildcardPattern;

public class SequentialFileInputStream
extends InputStream {
    static Logger log = LoggerFactory.getLogger(SequentialFileInputStream.class);
    static final Comparator<File> FILE_ORDER = new Comparator<File>(){

        @Override
        public int compare(File arg0, File arg1) {
            if (arg0 == arg1 || arg0.compareTo(arg1) == 0) {
                return 0;
            }
            Long lastModified = new Long(arg0.lastModified());
            int rc = lastModified.compareTo(arg1.lastModified());
            if (rc == 0) {
                return arg0.getName().compareTo(arg1.getName());
            }
            return rc;
        }
    };
    Integer sleep = 500;
    File file = null;
    File current = null;
    File next = null;
    InputStream reader;
    String pattern = "";
    boolean closed = false;
    long maxWaitingTime = -1L;
    long read = 0L;
    long total = 0L;
    long waitingTime = 0L;
    boolean removeAfterRead = true;
    Set<File> finished = new TreeSet<File>(FILE_ORDER);
    final LinkedBlockingQueue<File> sequence = new LinkedBlockingQueue();

    public SequentialFileInputStream(File file) throws IOException {
        this(file, false);
    }

    public SequentialFileInputStream(File file, boolean removeAfterRead) throws IOException {
        this(file, file.getName() + "*", removeAfterRead);
    }

    public SequentialFileInputStream(final File file, final String pattern, boolean removeAfterRead) throws IOException {
        this.current = this.file = file;
        this.pattern = pattern;
        this.removeAfterRead = removeAfterRead;
        this.monitorDirectory(file.getParentFile(), pattern);
        TimerTask watcher = new TimerTask(){

            @Override
            public void run() {
                SequentialFileInputStream.this.monitorDirectory(file.getParentFile(), pattern);
            }
        };
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(watcher, 0L, 1000L);
    }

    protected void monitorDirectory(File dir, String pattern) {
        log.debug("Creating sequence from directory '{}', pattern '{}'", (Object)dir, (Object)pattern);
        TreeSet<File> files = new TreeSet<File>(FILE_ORDER);
        File[] fs = dir.listFiles();
        if (fs != null) {
            for (File f : fs) {
                if (!WildcardPattern.matches((String)pattern, (String)f.getName())) continue;
                if (this.current.equals(f) || this.finished.contains(f)) {
                    log.debug("Skipping file {} which is already finished.", (Object)f);
                    continue;
                }
                log.debug("Adding new file {}", (Object)f);
                files.add(f);
            }
        }
        for (File f : files) {
            if (this.sequence.contains(f)) continue;
            log.debug("Adding file {} to sequence...", (Object)f);
            this.sequence.add(f);
        }
    }

    public boolean matchesSequence(File f) {
        if (f.getAbsolutePath().equals(this.file.getAbsolutePath())) {
            return false;
        }
        if (f.isFile() && !f.equals(this.file) && f.getName().matches(this.pattern)) {
            return !this.finished.contains(f);
        }
        return false;
    }

    public File getCurrentFile() {
        return this.current;
    }

    protected boolean hasNext() {
        return true;
    }

    protected void openNextFile() throws IOException {
        log.debug("Current file {} seems to have ended, checking for next one", (Object)this.current);
        boolean proceeded = false;
        do {
            try {
                File file;
                if (this.current != null) {
                    log.debug("Marking file '{}' as finished...", (Object)this.current);
                    this.finished.add(this.current);
                }
                if ((file = this.sequence.take()) != null) {
                    log.debug("Proceeding with file {}", (Object)file);
                    this.current = file;
                    this.read = 0L;
                    this.reader = new FileInputStream(this.current);
                    return;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (!proceeded);
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        while (this.reader == null) {
            this.openNextFile();
        }
        int data = this.reader.read();
        if (data == -1) {
            log.info("File {} seems to have finished!", (Object)this.current);
        }
        while (data == -1) {
            this.openNextFile();
            data = this.reader.read();
            if (data != -1) continue;
            log.info("Opened next file '{}' but still reading '-1'!?", (Object)this.current);
        }
        ++this.read;
        ++this.total;
        return data;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int available() throws IOException {
        if (this.reader == null) {
            return super.available();
        }
        return this.reader.available();
    }

    public static void main(String[] args) throws Exception {
        File input = new File("/tmp/test.log");
        SequentialFileInputStream f = new SequentialFileInputStream(input, false);
        PrintStream out = new PrintStream(new FileOutputStream(new File(input.getAbsolutePath() + "-complete")));
        byte[] buf = new byte[1024];
        int read = 0;
        int written = 0;
        do {
            if (f.available() > 0) {
                buf = new byte[Math.min(1024, f.available())];
            }
            if ((read = f.read(buf)) >= 0) {
                written += read;
                out.write(buf, 0, read);
                out.flush();
            }
            log.debug("{} bytes written", (Object)written);
        } while (read > 0);
    }
}

