/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit;

import org.jwall.audit.Event;
import org.jwall.audit.EventType;
import org.jwall.web.audit.AuditEvent;
import stream.data.DataImpl;

public class AuditData
extends DataImpl
implements Event {
    private static final long serialVersionUID = 3092385126433800772L;
    public static final String TIMESTAMP_KEY = "@timestamp";

    public AuditData() {
        this.put(TIMESTAMP_KEY, new Long(System.currentTimeMillis()));
    }

    public AuditData(AuditEvent evt) {
        this.put(TIMESTAMP_KEY, evt.getDate().getTime());
        for (int i = 0; i < "ABCDEFGHIJKTXZ".length(); ++i) {
            String sect = evt.getSection(i);
            if (sect == null) continue;
            this.put("section:" + "ABCDEFGHIJKTXZ".charAt(i), sect);
        }
    }

    @Override
    public Long getTimestamp() {
        return (Long)super.get((Object)TIMESTAMP_KEY);
    }

    @Override
    public final EventType getType() {
        return EventType.AUDIT;
    }

    @Override
    public String get(String variableName) {
        if (this.containsKey(variableName)) {
            return super.get((Object)variableName) + "";
        }
        return null;
    }

    @Override
    public void set(String variable, String value) {
        this.put(variable, value);
    }
}

