/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.jwall.web.audit.AuditEventMessage;
import org.jwall.web.audit.ModSecurity;

public class ModSecurityEventMessage
implements AuditEventMessage {
    private static final long serialVersionUID = -2274796492823296560L;
    private static Long instanceCount = 0L;
    String txId = "";
    String text = null;
    String file = null;
    Integer line = null;
    String ruleMsg = null;
    String ruleId = null;
    String ruleData = null;
    List<String> ruleTags = null;
    Integer severity = 15;
    Date date = new Date();

    public String toString() {
        StringBuilder b = new StringBuilder("Message:");
        if (this.text != null) {
            b.append(" ");
            b.append(this.text);
        }
        if (this.file != null) {
            b.append(" [file \"" + this.file + "\"]");
        }
        if (this.line != null) {
            b.append(" [line \"" + this.line + "\"]");
        }
        if (this.ruleId != null) {
            b.append(" [id \"" + this.ruleId + "\"]");
        }
        if (this.ruleMsg != null) {
            b.append(" [msg \"" + this.ruleMsg + "\"]");
        }
        if (this.severity != null && this.severity >= 0 && this.severity < ModSecurity.SEVERITIES.length) {
            b.append(" [severity \"" + ModSecurity.SEVERITIES[this.severity] + "\"]");
        }
        if (this.ruleData != null) {
            b.append(" [data \"" + this.ruleData + "\"]");
        }
        if (this.ruleTags != null && !this.ruleTags.isEmpty()) {
            Iterator<String> it = this.ruleTags.iterator();
            while (it.hasNext()) {
                b.append(" [tag \"" + it.next() + "\"]");
            }
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModSecurityEventMessage() {
        Long l = instanceCount;
        synchronized (l) {
            Long l2 = instanceCount;
            Long l3 = instanceCount = Long.valueOf(instanceCount + 1L);
        }
    }

    @Override
    public String getTxId() {
        return this.txId;
    }

    public void setTxId(String eventId) {
        this.txId = eventId;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    @Override
    public Integer getLine() {
        return this.line;
    }

    public void setLine(Integer line) {
        this.line = line;
    }

    @Override
    public String getRuleMsg() {
        return this.ruleMsg;
    }

    public void setRuleMsg(String ruleMsg) {
        this.ruleMsg = ruleMsg;
    }

    @Override
    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    @Override
    public String getRuleData() {
        return this.ruleData;
    }

    public void setRuleData(String ruleData) {
        this.ruleData = ruleData;
    }

    @Override
    public List<String> getRuleTags() {
        return this.ruleTags;
    }

    public void setRuleTags(List<String> ruleTags) {
        this.ruleTags = ruleTags;
    }

    @Override
    public Integer getSeverity() {
        return this.severity;
    }

    public void setSeverity(Integer sev) {
        this.severity = sev;
    }

    public String getTag() {
        if (this.ruleTags == null || this.ruleTags.isEmpty()) {
            return null;
        }
        return this.ruleTags.get(0);
    }

    public void setTag(String tag) {
        if (this.ruleTags == null) {
            this.ruleTags = new ArrayList<String>();
        }
        this.ruleTags.add(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        Long l = instanceCount;
        synchronized (l) {
            Long l2 = instanceCount;
            Long l3 = instanceCount = Long.valueOf(instanceCount - 1L);
        }
    }

    public static Long getInstanceCount() {
        return instanceCount;
    }
}

