/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.processor;

import java.io.BufferedReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;

public class HttpHeaderParser
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(HttpHeaderParser.class);
    String section;
    String firstLine;
    String collection;

    public HttpHeaderParser() {
        this("HTTP_REQUEST_HEADERS", "REQUEST_HEADERS", "REQUEST_LINE");
    }

    public HttpHeaderParser(String section, String collectionName, String nameOfFirstLine) {
        this.section = section;
        this.firstLine = nameOfFirstLine;
        this.collection = collectionName;
    }

    public String getCollection() {
        return this.collection;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public Data process(Data data) {
        if (data.get((Object)this.section) != null) {
            String headerData = ((Serializable)data.get((Object)this.section)).toString();
            Map<String, String> headers = this.parseHeader(headerData);
            data.putAll(headers);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> parseHeader(String header) {
        BufferedReader reader = null;
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        try {
            reader = new BufferedReader(new StringReader(header));
            String first = reader.readLine();
            if (first == null) {
                LinkedHashMap<String, String> linkedHashMap = headers;
                return linkedHashMap;
            }
            if (this.firstLine != null) {
                headers.put(this.firstLine, first);
            }
            String line = reader.readLine();
            while (line != null) {
                int idx = line.indexOf(": ");
                if (idx > 0) {
                    String key = line.substring(0, idx);
                    String val = line.substring(idx + 2);
                    log.info("Adding {}={}", (Object)(this.collection + ":" + key), (Object)val);
                    headers.put(this.collection + ":" + key, val);
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return headers;
    }
}

