/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.session;

import java.net.InetAddress;
import java.util.Date;
import java.util.Hashtable;
import java.util.Set;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.session.SessionContext;

public class Session
implements Comparable<Session>,
SessionContext {
    public static final int COOKIE_BASED = 1;
    public static final int PARAMETER_BASED = 2;
    public static final int HEURISTIC_BASED = 3;
    private int type;
    private String id;
    private Date firstAccessed;
    private Date lastAccessed;
    private InetAddress address;
    private double score = 0.0;
    Hashtable<String, String> sessionVariables = new Hashtable();

    public Session(int type, String id, AuditEvent evt) {
        this.id = id;
        this.type = type;
        if (evt != null) {
            try {
                this.address = InetAddress.getByName(evt.get("REMOTE_ADDR"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.lastAccessed = this.firstAccessed = evt.getDate();
        }
    }

    public int getType() {
        return this.type;
    }

    public void setInetAddress(InetAddress addr) {
        this.address = addr;
    }

    public InetAddress getInetAddress() {
        return this.address;
    }

    public Date lastAccessed() {
        return new Date(this.lastAccessed.getTime());
    }

    public Date firstAccessed() {
        return new Date(this.firstAccessed.getTime());
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Session)) {
            return false;
        }
        Session other = (Session)o;
        return this.id.equals(other.id);
    }

    public void addEvent(AuditEvent e) {
        if (e.getDate().after(this.lastAccessed())) {
            this.lastAccessed = e.getDate();
        }
    }

    @Override
    public int compareTo(Session s) {
        return this.id.compareTo(s.id);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.getId() + " ~> ");
        return s.toString();
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double d) {
        this.score = d;
    }

    @Override
    public String getVariable(String name) {
        if (name != null && this.sessionVariables.containsKey(name)) {
            return this.sessionVariables.get(name);
        }
        return null;
    }

    @Override
    public Set<String> getVariableNames() {
        return this.sessionVariables.keySet();
    }

    @Override
    public void increment(String var, int count) {
        Integer d;
        String val = this.getVariable(var);
        if (val == null || !val.matches("\\d+")) {
            return;
        }
        Integer n = d = new Integer(val);
        Integer n2 = d = Integer.valueOf(d + 1);
        this.sessionVariables.put(var, d.toString());
    }

    @Override
    public void setVariable(String name, String value, Date expires) {
        this.sessionVariables.put(name, value);
    }

    @Override
    public void removeVariable(String name) {
        if (this.sessionVariables.containsKey(name)) {
            this.sessionVariables.remove(name);
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

