/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.annotations.Parameter;
import stream.data.Data;
import stream.expressions.ExpressionResolver;
import stream.service.LookupService;

public class Lookup
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(Lookup.class);
    protected LookupService lookup;
    protected String key;

    public LookupService getLookup() {
        return this.lookup;
    }

    public void setLookup(LookupService lookup) {
        this.lookup = lookup;
    }

    public String getKey() {
        return this.key;
    }

    @Parameter(defaultValue="@id")
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public Data process(Data item) {
        if (this.lookup == null) {
            log.error("No LookupService injected!");
            return item;
        }
        String varib = ExpressionResolver.resolve(this.key, this.context, item).toString();
        Data lookupData = this.lookup.lookup(varib);
        item.putAll(lookupData);
        return item;
    }
}

