/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Processor;
import stream.annotations.Description;
import stream.annotations.Parameter;
import stream.data.Data;

@Description(text="", group="Data Stream.Processing.Transformations.Attributes")
public class MapKeys
implements Processor {
    static Logger log = LoggerFactory.getLogger(MapKeys.class);
    String oldKey;
    String newKey;
    String map;
    Map<String, String> mapping = new LinkedHashMap<String, String>();

    public MapKeys(String oldKey, String newKey) {
        this.oldKey = oldKey;
        this.newKey = newKey;
    }

    public MapKeys() {
        this.oldKey = "";
        this.newKey = "";
    }

    public String getFrom() {
        return this.oldKey;
    }

    public void setFrom(String oldKey) {
        this.oldKey = oldKey;
    }

    public String getTo() {
        return this.newKey;
    }

    public void setTo(String newKey) {
        this.newKey = newKey;
    }

    public String getMap() {
        return this.map;
    }

    @Parameter(name="map", required=false)
    public void setMap(String map) {
        try {
            if (map == null || map.trim().isEmpty()) {
                return;
            }
            File file = new File(map);
            Properties p = new Properties();
            p.load(new FileInputStream(file));
            for (Object key : p.keySet()) {
                this.mapping.put(key.toString(), p.getProperty(key.toString()));
            }
            this.map = map;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Data process(Data input) {
        if (this.oldKey != null && this.newKey != null && input.containsKey(this.oldKey)) {
            if (input.containsKey(this.newKey)) {
                log.warn("Overwriting existing key '{}'!", (Object)this.newKey);
            }
            Serializable o = (Serializable)input.remove(this.oldKey);
            input.put(this.newKey, o);
        }
        for (String key : this.mapping.keySet()) {
            if (!input.containsKey(key)) continue;
            Serializable value = (Serializable)input.remove(key);
            input.put(this.mapping.get(key), value);
        }
        return input;
    }

    public Map<String, String> getMapping() {
        return this.mapping;
    }

    @Parameter(required=true, description="A list of key mappings.")
    public void setMapping(Map<String, String> mapping) {
        this.mapping = mapping;
    }
}

