/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import stream.Processor;
import stream.annotations.Description;
import stream.data.Data;

@Description(text="", group="Data Stream.Processing.Transformations.Data")
public class MapValues
implements Processor {
    String key = "@label";
    String map;
    Serializable defaultValue = new Double(-1.0);
    Map<Serializable, Serializable> mapping = new HashMap<Serializable, Serializable>();
    String from = null;
    String to = null;

    public void addMapping(Serializable from, Serializable to) {
        this.mapping.put(from, to);
    }

    public void setDefault(Serializable defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Serializable getDefault() {
        return this.defaultValue;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getMap() {
        return this.map;
    }

    public void setMap(String map) {
        try {
            File file = new File(map);
            Properties p = new Properties();
            p.load(new FileInputStream(file));
            for (Object key : p.keySet()) {
                this.mapping.put((Serializable)((Object)key.toString()), (Serializable)((Object)p.getProperty(key.toString())));
            }
            this.map = map;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    @Override
    public Data process(Data data) {
        Serializable to;
        Serializable val = (Serializable)data.get(this.key);
        if (val == null) {
            return data;
        }
        if (this.from != null && this.to != null && this.from.equals(val.toString())) {
            data.put(this.key, this.to);
        }
        if ((to = this.mapping.get(val)) == null) {
            data.put(this.key, to);
        } else {
            data.put(this.key, this.defaultValue);
        }
        return data;
    }
}

