/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.util.Random;
import stream.Processor;
import stream.annotations.Description;
import stream.data.Data;

@Description(group="Data Stream.Processing.Transformations.Data")
public class RandomBinaryLabel
implements Processor {
    Long seed = System.currentTimeMillis();
    Random random = new Random();
    String labelAttribute = "@label";

    public Long getSeed() {
        return this.seed;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
        if (seed != null) {
            this.random = new Random(seed);
        }
    }

    public String getKey() {
        return this.labelAttribute;
    }

    public void setKey(String labelAttribute) {
        this.labelAttribute = labelAttribute;
    }

    @Override
    public Data process(Data data) {
        Double val = this.random.nextDouble();
        if (val < 0.5) {
            data.put(this.labelAttribute, -1.0);
        } else {
            data.put(this.labelAttribute, 1.0);
        }
        return data;
    }
}

