/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.ConditionedProcessor;
import stream.annotations.Description;
import stream.annotations.Parameter;
import stream.data.Data;
import stream.expressions.ExpressionResolver;

@Description(group="Data Stream.Processing.Transformations.Data")
public class SetValue
extends ConditionedProcessor {
    static Logger log = LoggerFactory.getLogger(SetValue.class);
    protected String key;
    protected String value;
    protected List<String> scope = new ArrayList<String>();

    @Override
    public Data processMatchingData(Data data) {
        if (this.key != null && this.value != null) {
            String val = String.valueOf(ExpressionResolver.resolve(this.value, this.context, data));
            if (this.scope.contains("data") || this.scope.isEmpty()) {
                data.put(this.key, val);
            }
            if (this.scope.contains("process")) {
                this.context.set(this.key, val);
            }
        }
        return data;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String[] getScope() {
        return this.scope.toArray(new String[this.scope.size()]);
    }

    @Parameter(defaultValue="data", required=false)
    public void setScope(String[] scope) {
        this.scope = Arrays.asList(scope);
    }
}

