/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.ProcessorList;
import stream.data.Data;
import stream.data.DataFactory;
import stream.util.WildcardPattern;

public class WithKeys
extends ProcessorList {
    static Logger log = LoggerFactory.getLogger(WithKeys.class);
    String[] keys = null;
    Set<String> selected = new HashSet<String>();
    private Boolean remove = true;

    public void setKeys(String[] keys) {
        this.keys = keys;
        for (String key : keys) {
            this.selected.add(key);
        }
    }

    public String[] getKeys() {
        return this.keys;
    }

    public void setRemove(Boolean remove) {
        this.remove = remove;
    }

    public Boolean getRemove() {
        return this.remove;
    }

    @Override
    public Data process(Data data) {
        if (this.keys == null || this.keys.length == 0) {
            return data;
        }
        Data result = DataFactory.create();
        for (String key : data.keySet()) {
            if (!this.isSelected(key)) continue;
            result.put(key, data.get(key));
        }
        Data processed = super.process(result);
        for (String key : processed.keySet()) {
            data.put(key, processed.get(key));
        }
        return data;
    }

    public boolean isSelected(String key) {
        if (this.keys == null || this.keys.length == 0) {
            return false;
        }
        boolean included = false;
        for (String k : this.keys) {
            if (k.startsWith("!")) {
                k = k.substring(1);
                if (included && WildcardPattern.matches(k, key)) {
                    included = false;
                }
                log.debug("Removing '{}' from selection due to pattern '!{}'", (Object)key, (Object)k);
                continue;
            }
            if (included || !WildcardPattern.matches(k, key)) continue;
            included = true;
            log.debug("Adding '{}' to selection due to pattern '{}'", (Object)key, (Object)k);
        }
        return included;
    }
}

