/*
 * Decompiled with CFR 0.152.
 */
package stream.expressions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.expressions.Expression;
import stream.expressions.ExpressionException;
import stream.expressions.ExpressionList;
import stream.expressions.ExpressionReader;

public class ExpressionCompiler {
    static Logger log = LoggerFactory.getLogger(ExpressionCompiler.class);

    public static final Expression parse(String str) throws ExpressionException {
        log.debug("Parsing expression: '{}'", (Object)str);
        if (str == null || str.trim().isEmpty()) {
            return null;
        }
        ExpressionReader r = new ExpressionReader(str);
        return r.readFilterExpression();
    }

    public static final Expression parse(String str, Collection<String> variables) throws ExpressionException {
        log.debug("Parsing expression: '{}'", (Object)str);
        ExpressionReader r = new ExpressionReader(str, variables);
        return r.readFilterExpression();
    }

    public static List<Expression> expand(ExpressionList list) {
        LinkedList<Expression> exp = new LinkedList<Expression>();
        for (Expression e : list.getElements()) {
            if (e instanceof ExpressionList) {
                exp.addAll(ExpressionCompiler.expand((ExpressionList)e));
                continue;
            }
            exp.add(e);
        }
        return exp;
    }
}

