/*
 * Decompiled with CFR 0.152.
 */
package stream.expressions;

import stream.Context;
import stream.data.Data;

public class ExpressionResolver {
    public static final String MACRO_START = "%{";
    public static final String MACRO_END = "}";

    public static String[] extractName(String variable) {
        String var;
        if (variable != null && (var = variable.trim()).startsWith(MACRO_START) && var.endsWith(MACRO_END)) {
            if ((var = var.substring(MACRO_START.length(), var.length() - 1)).indexOf(".") >= 0) {
                return var.split("\\.", 2);
            }
            return new String[]{"", var};
        }
        return new String[]{"", variable};
    }

    public static Object resolve(String variable, Context ctx, Data item) {
        if (variable == null) {
            return null;
        }
        if (!variable.contains(MACRO_START)) {
            return variable;
        }
        String varString = variable.trim();
        if (varString.startsWith(MACRO_START) && varString.endsWith(MACRO_END)) {
            if ((varString = varString.substring(MACRO_START.length(), varString.length() - 1)).startsWith("data.")) {
                return item.get(varString.substring(5));
            }
            if (ctx != null) {
                return ctx.resolve(varString);
            }
        }
        return null;
    }

    public static boolean isMacroObject(String variable) {
        String var;
        return variable != null && (var = variable.trim()).startsWith(MACRO_START) && var.endsWith(MACRO_END);
    }

    public static String expand(String str, Context ctx, Data item) {
        boolean started = false;
        boolean prestart = false;
        StringBuilder sb = new StringBuilder();
        StringBuilder macro = null;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '%') {
                prestart = true;
                continue;
            }
            if (str.charAt(i) == '{' && prestart) {
                macro = new StringBuilder();
                started = true;
                prestart = false;
                continue;
            }
            if (started) {
                if (str.charAt(i) == '}') {
                    started = false;
                    Object o = null;
                    String s = macro.toString();
                    if (s.startsWith("data.")) {
                        o = item.get(s.substring(5));
                    } else if (ctx != null) {
                        o = ctx.resolve(s);
                    }
                    if (o == null) continue;
                    sb.append(o.toString());
                    continue;
                }
                macro.append(str.charAt(i));
                continue;
            }
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }
}

