/*
 * Decompiled with CFR 0.152.
 */
package stream.flow;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.data.Data;
import stream.data.DataFactory;
import stream.expressions.ExpressionResolver;
import stream.flow.Enqueue;

public class CreateAndEnqueue
extends Enqueue {
    static Logger log = LoggerFactory.getLogger(CreateAndEnqueue.class);
    String ref = null;
    protected String[] keys = null;
    protected Boolean stringOnly = false;

    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public Boolean isStringOnly() {
        return this.stringOnly;
    }

    public void setStringOnly(Boolean stringOnly) {
        this.stringOnly = stringOnly;
    }

    @Override
    public Data process(Data data) {
        if (this.queues == null) {
            log.error("No QueueService injected!");
            return data;
        }
        Data result = DataFactory.create();
        for (String key : this.keys) {
            Object o = ExpressionResolver.resolve(key, this.context, data);
            if (o == null) continue;
            String[] s = ExpressionResolver.extractName(key);
            Serializable ser = this.create(o);
            if (ser == null) continue;
            result.put(s[1], ser);
        }
        if (!result.isEmpty()) {
            this.enqueue(result);
        }
        return data;
    }

    private Serializable create(Object object) {
        if (!this.stringOnly.booleanValue() && this.isNumeric(object)) {
            return new Double(object.toString());
        }
        return object.toString();
    }

    public boolean isNumeric(Object val) {
        if (val instanceof Double) {
            return true;
        }
        if (val == null) {
            return false;
        }
        try {
            new Double(val.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

