/*
 * Decompiled with CFR 0.152.
 */
package stream.flow;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.data.Data;
import stream.data.DataFactory;
import stream.expressions.ExpressionResolver;
import stream.flow.MultiEnqueue;

public class CreateAndMultiEnqueue
extends MultiEnqueue {
    static Logger log = LoggerFactory.getLogger(CreateAndMultiEnqueue.class);
    String ref = null;
    protected String[] keys = null;

    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    @Override
    public String[] getKeys() {
        return this.keys;
    }

    @Override
    public Data process(Data data) {
        if (this.queues == null || this.queues.length == 0) {
            log.error("No QueueService injected!");
            return data;
        }
        Data result = DataFactory.create();
        for (String key : this.keys) {
            Object o = ExpressionResolver.resolve(key, this.context, data);
            if (o == null) continue;
            String[] s = ExpressionResolver.extractName(key);
            result.put(s[1], this.create(o));
        }
        this.enqueue(result);
        return data;
    }

    private Serializable create(Object object) {
        if (this.isNumeric(object)) {
            return new Double(object.toString());
        }
        return object.toString();
    }

    public boolean isNumeric(Object val) {
        if (val instanceof Double) {
            return true;
        }
        if (val == null) {
            return false;
        }
        try {
            new Double(val.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

