/*
 * Decompiled with CFR 0.152.
 */
package stream.flow;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.ProcessorList;
import stream.annotations.Description;
import stream.annotations.Parameter;
import stream.data.Data;
import stream.expressions.Expression;
import stream.expressions.ExpressionCompiler;

@Description(group="Data Stream.Flow")
public class If
extends ProcessorList {
    static Logger log = LoggerFactory.getLogger(If.class);
    Expression condition;

    public String getCondition() {
        if (this.condition == null) {
            return "";
        }
        return this.condition.toString();
    }

    @Parameter(name="condition", required=false)
    public void setCondition(String condition) {
        try {
            if (condition == null || "".equals(condition.trim())) {
                condition = null;
                return;
            }
            this.condition = ExpressionCompiler.parse(condition);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public boolean matches(Data item) {
        return this.condition == null || this.condition.matches(this.context, item);
    }

    @Override
    public Data process(Data input) {
        if (this.matches(input)) {
            log.debug("processing item {}", input);
            return super.process(input);
        }
        log.debug("skipping item {}", input);
        return input;
    }
}

