/*
 * Decompiled with CFR 0.152.
 */
package stream.flow;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.ProcessContext;
import stream.data.Data;
import stream.io.QueueService;

public class MultiEnqueue
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(MultiEnqueue.class);
    String ref = null;
    protected String[] queuesNames;
    protected QueueService[] queues;

    public void setQueues(String[] queues) {
        this.queuesNames = queues;
    }

    public String[] getKeys() {
        return this.queuesNames;
    }

    @Override
    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        this.queues = new QueueService[this.queuesNames.length];
        for (int i = 0; i < this.queuesNames.length; ++i) {
            this.queues[i] = this.context.lookup(this.queuesNames[i], QueueService.class);
        }
    }

    @Override
    public Data process(Data data) {
        if (this.queues == null || this.queues.length == 0) {
            log.error("No QueueService injected!");
            return data;
        }
        this.enqueue(data);
        return data;
    }

    protected void enqueue(Data data) {
        for (QueueService qs : this.queues) {
            qs.enqueue(data);
        }
    }
}

