/*
 * Decompiled with CFR 0.152.
 */
package stream.generator;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import stream.data.Data;
import stream.data.DataFactory;
import stream.generator.GeneratorDataStream;
import stream.io.DataStream;

public class MixedStream
extends GeneratorDataStream {
    Map<String, Class<?>> types = new LinkedHashMap();
    Double totalWeight = 0.0;
    List<Double> weights = new ArrayList<Double>();
    List<DataStream> streams = new ArrayList<DataStream>();
    Random rnd = new Random();

    @Override
    public Map<String, Class<?>> getAttributes() {
        return this.types;
    }

    public void add(Double weight, DataStream stream) {
        this.streams.add(stream);
        this.weights.add(this.totalWeight + weight);
        this.types.putAll(stream.getAttributes());
        this.totalWeight = this.totalWeight + weight;
    }

    protected int choose() {
        double d = this.rnd.nextDouble();
        Double t = d * this.totalWeight;
        for (int i = 0; i < this.weights.size(); ++i) {
            if (i + 1 >= this.weights.size() || !(this.weights.get(i + 1) > t)) continue;
            return i;
        }
        return this.weights.size() - 1;
    }

    @Override
    public Data readNext() throws Exception {
        return this.readNext(DataFactory.create());
    }

    @Override
    public Data readNext(Data datum) throws Exception {
        int i = this.choose();
        return this.streams.get(i).readNext(datum);
    }

    public static void main(String[] args) throws Exception {
        MixedStream ms = new MixedStream();
        ms.readNext();
    }

    @Override
    public void close() {
    }
}

