/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Processor;
import stream.annotations.Parameter;
import stream.data.Data;
import stream.data.DataFactory;
import stream.io.DataStream;

public abstract class AbstractDataStream
implements DataStream {
    static Logger log = LoggerFactory.getLogger(AbstractDataStream.class);
    URL url;
    String username;
    String password;
    LinkedHashMap<String, Class<?>> attributes = new LinkedHashMap();
    BufferedReader reader;
    Long limit = -1L;
    Long count = 0L;
    String prefix = null;
    ArrayList<Processor> preprocessors = new ArrayList();

    protected AbstractDataStream() {
    }

    public AbstractDataStream(URL url) throws Exception {
        this.url = url;
    }

    public AbstractDataStream(URL url, String username, String password) throws Exception {
        this.url = url;
        this.username = username;
        this.password = password;
        this.initReader();
    }

    protected void initReader() throws Exception {
        if (this.username != null && this.password != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(AbstractDataStream.this.username, AbstractDataStream.this.password.toCharArray());
                }
            });
        }
        this.reader = this.url.getFile().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(this.url.openStream()))) : new BufferedReader(new InputStreamReader(this.url.openStream()));
        this.readHeader();
    }

    public AbstractDataStream(InputStream in) throws Exception {
        this.reader = new BufferedReader(new InputStreamReader(in));
    }

    @Override
    public Map<String, Class<?>> getAttributes() {
        return this.attributes;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Parameter(required=false, description="An optional prefix string to prepend to all attribute names", defaultValue="")
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Long getLimit() {
        return this.limit;
    }

    @Parameter(required=false, description="The maximum number of items that this stream should deliver", defaultValue="-1", max=9.223372036854776E18)
    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public String getUsername() {
        return this.username;
    }

    @Parameter(name="username", description="The username required to connect to the stream URL (e.g web-user, database user)", required=false)
    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    @Parameter(name="password", description="The password for the stream URL (see username parameter)", required=false)
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public List<Processor> getPreprocessors() {
        return this.preprocessors;
    }

    public void addPreprocessor(Processor proc) {
        this.preprocessors.add(proc);
    }

    public void addPreprocessor(int idx, Processor proc) {
        this.preprocessors.add(idx, proc);
    }

    public boolean removePreprocessor(Processor proc) {
        return this.preprocessors.remove(proc);
    }

    public Processor removePreprocessor(int idx) {
        return this.preprocessors.remove(idx);
    }

    @Override
    public void init() throws Exception {
    }

    public abstract void readHeader() throws Exception;

    public abstract Data readItem(Data var1) throws Exception;

    @Override
    public final Data readNext(Data item) throws Exception {
        if (this.limit > 0L && this.count >= this.limit) {
            return null;
        }
        Data datum = null;
        while (datum == null) {
            Processor proc;
            datum = this.readItem(item);
            if (datum == null) {
                log.debug("End-of-stream reached!");
                return null;
            }
            if (this.prefix != null && !this.prefix.trim().isEmpty()) {
                Data prefixed = DataFactory.create();
                for (String key : datum.keySet()) {
                    prefixed.put(this.prefix + ":" + key, datum.get(key));
                }
                datum = prefixed;
            }
            Iterator<Processor> i$ = this.preprocessors.iterator();
            while (i$.hasNext() && (datum = (proc = i$.next()).process(datum)) != null) {
            }
        }
        Long l = this.count;
        Long l2 = this.count = Long.valueOf(this.count + 1L);
        return datum;
    }

    @Override
    public Data readNext() throws Exception {
        return this.readNext(DataFactory.create());
    }
}

