/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import stream.AbstractProcessor;
import stream.ProcessContext;
import stream.annotations.Description;
import stream.annotations.Parameter;
import stream.data.Data;
import stream.expressions.ExpressionResolver;

@Description(group="Data Stream.Output")
public class LineWriter
extends AbstractProcessor {
    File file;
    boolean append = false;
    PrintStream out;
    String format = null;
    boolean escapeNewlines = true;

    public File getFile() {
        return this.file;
    }

    @Parameter(required=true, description="Name of the file to write to.")
    public void setFile(File file) {
        this.file = file;
    }

    public String getFormat() {
        return this.format;
    }

    @Parameter(required=true, description="The format string, containing macros that are expanded for each item")
    public void setFormat(String format) {
        this.format = format;
    }

    public boolean isAppend() {
        return this.append;
    }

    @Parameter(required=false, description="Denotes whether to append to existing files or create a new file at container startup.", defaultValue="false")
    public void setAppend(boolean append) {
        this.append = append;
    }

    public boolean isEscapeNewlines() {
        return this.escapeNewlines;
    }

    @Parameter(required=false, description="Whether to escape newlines contained in the attributes or not.")
    public void setEscapeNewlines(boolean escapeNewlines) {
        this.escapeNewlines = escapeNewlines;
    }

    @Override
    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        this.out = new PrintStream(new FileOutputStream(this.file, this.append));
    }

    @Override
    public Data process(Data input) {
        if (input == null || this.format == null) {
            return input;
        }
        String line = ExpressionResolver.expand(this.format, this.context, input);
        if (this.escapeNewlines) {
            while (line.indexOf("\n") >= 0) {
                line = line.replace("\n", "\\n");
            }
        }
        this.out.println(line);
        return input;
    }

    @Override
    public void finish() throws Exception {
        super.finish();
    }
}

