/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import stream.data.Data;
import stream.data.DataUtils;
import stream.io.CsvWriter;

public class SvmLightWriter
extends CsvWriter {
    Map<String, Integer> indexes = new HashMap<String, Integer>();
    Integer largestIndex = 0;
    boolean includeAnnotations = true;

    public SvmLightWriter() {
    }

    public SvmLightWriter(OutputStream out) {
        super(out);
    }

    @Override
    public void writeHeader(Data datum) {
    }

    @Override
    public void write(Data datum) {
        Serializable label = (Serializable)datum.get("@label");
        if (label == null) {
            log.error("SvmLightStreamWriter does only support writing labeled data!");
            log.error("Skipping datum {}", datum);
            return;
        }
        this.p.print(label);
        StringBuffer annotation = new StringBuffer();
        for (String key : DataUtils.getKeys(datum)) {
            try {
                Double value = new Double(((Serializable)datum.get(key)).toString());
                this.p.print(" ");
                Integer index = -1;
                if (key.matches("\\d+")) {
                    index = new Integer(key);
                } else {
                    index = this.indexes.get(key);
                    if (index == null) {
                        index = this.largestIndex + 1;
                        this.indexes.put(key, index);
                    }
                }
                if (this.largestIndex < index) {
                    this.largestIndex = index;
                }
                this.p.print(index);
                this.p.print(":");
                this.p.print(value);
            }
            catch (Exception e) {
                log.debug("Skipping non-numerical feature '{}'", (Object)key);
                annotation.append(" ");
                annotation.append(key);
                annotation.append(":'");
                annotation.append(this.lineEscape((Serializable)datum.get(key)));
                annotation.append("'");
            }
        }
        if (this.includeAnnotations && annotation.length() > 0) {
            this.p.print(" #");
            this.p.print(annotation.toString());
        }
        this.p.println();
    }

    public boolean isIncludeAnnotations() {
        return this.includeAnnotations;
    }

    public void setIncludeAnnotations(boolean includeAnnotations) {
        this.includeAnnotations = includeAnnotations;
    }

    protected String lineEscape(Serializable val) {
        if (val == null) {
            return "";
        }
        String str = val.toString();
        return str.replaceAll("'", ",").replaceAll("\\n", " ");
    }

    public void printMapping(File file) throws Exception {
        FileOutputStream fos = new FileOutputStream(file);
        this.printMapping(fos);
        fos.close();
    }

    public void printMapping(OutputStream out) {
        PrintStream p = new PrintStream(out);
        p.println("#feature,index");
        for (String key : this.indexes.keySet()) {
            p.println(key + "," + this.indexes.get(key));
        }
        p.flush();
        p.close();
    }
}

