/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import stream.data.Data;
import stream.data.DataFactory;
import stream.io.AbstractDataStream;
import stream.util.parser.TimeParser;

public class TimeStream
extends AbstractDataStream {
    String key = "@timestamp";
    String interval = "";
    Long gap = -1L;
    long last = 0L;

    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
        try {
            this.gap = TimeParser.parseTime(interval);
        }
        catch (Exception e) {
            this.gap = -1L;
            throw new RuntimeException("Invalid time string '" + interval + "': " + e.getMessage());
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void readHeader() throws Exception {
    }

    @Override
    public Data readItem(Data instance) throws Exception {
        if (instance == null) {
            instance = DataFactory.create();
        }
        Long timestamp = System.currentTimeMillis();
        if (this.gap > 0L) {
            long t = timestamp - timestamp % this.gap;
            long t2 = this.gap - (timestamp - t);
            try {
                if (t2 > 0L) {
                    Thread.sleep(t2);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            timestamp = System.currentTimeMillis();
        }
        this.last = timestamp;
        instance.put(this.key, timestamp);
        return instance;
    }
}

