/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Processor;
import stream.data.Data;
import stream.data.DataFactory;
import stream.data.TreeNode;
import stream.io.DataStream;
import stream.parser.DefaultTreeParser;

public class TreeStream
implements DataStream {
    static Logger log = LoggerFactory.getLogger(TreeStream.class);
    String treeAttribute = "tree";
    BufferedReader reader;
    DefaultTreeParser treeParser;
    Map<String, Class<?>> attributes = new LinkedHashMap();
    final List<Processor> processors = new ArrayList<Processor>();

    public TreeStream(URL url) throws Exception {
        this.reader = new BufferedReader(new InputStreamReader(url.openStream()));
        this.treeParser = new DefaultTreeParser();
        this.attributes.put("tree", TreeNode.class);
    }

    public String getTreeAttribute() {
        return this.treeAttribute;
    }

    public void setTreeAttribute(String treeAttribute) {
        this.treeAttribute = treeAttribute;
    }

    @Override
    public Map<String, Class<?>> getAttributes() {
        return this.attributes;
    }

    @Override
    public Data readNext() throws Exception {
        return this.readNext(DataFactory.create());
    }

    @Override
    public Data readNext(Data datum) throws Exception {
        if (datum == null) {
            datum = DataFactory.create();
        }
        String line = this.reader.readLine();
        while (line != null && line.startsWith("#")) {
            line = this.reader.readLine();
        }
        if (line == null) {
            return null;
        }
        TreeNode tree = this.treeParser.parse(line);
        datum.put(this.treeAttribute, tree);
        return datum;
    }

    @Override
    public List<Processor> getPreprocessors() {
        return this.processors;
    }

    @Override
    public void close() {
        block2: {
            try {
                this.reader.close();
            }
            catch (Exception e) {
                log.error("Failed to properly close reader: {}", (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block2;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void init() throws Exception {
    }
}

