/*
 * Decompiled with CFR 0.152.
 */
package stream.learner;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.data.Data;
import stream.data.Statistics;
import stream.learner.MetaDataService;

public class MetaDataLearner
extends AbstractProcessor
implements MetaDataService {
    static Logger log = LoggerFactory.getLogger(MetaDataLearner.class);
    String[] keys = null;
    final Set<String> observed = new LinkedHashSet<String>();
    Map<String, Statistics> stats = new LinkedHashMap<String, Statistics>();

    public String[] getKeys() {
        return this.keys;
    }

    public void setKeys(String[] keys) {
        this.keys = keys;
        if (this.keys != null) {
            for (String key : this.keys) {
                this.observed.add(key);
            }
        }
    }

    @Override
    public Data process(Data input) {
        if (this.keys == null) {
            this.observed.addAll(input.keySet());
        }
        for (String key : this.observed) {
            Serializable val = (Serializable)input.get(key);
            if (val == null) continue;
            Statistics st = this.stats.get(key);
            if (st == null) {
                log.debug("Creating new statistics object for attribute {}", (Object)key);
                st = new Statistics(key);
                this.stats.put(key, st);
            }
            if (val instanceof Double) {
                this.update(st, (Double)val);
                continue;
            }
            this.update(st, val.toString());
        }
        return input;
    }

    protected Statistics update(Statistics st, Double value) {
        Double min = (Double)st.get("minimum");
        min = min == null ? value : Double.valueOf(Math.min(min, value));
        st.put("minimum", min);
        Double max = (Double)st.get("maximum");
        max = max == null ? value : Double.valueOf(Math.max(max, value));
        st.put("maximum", max);
        st.add("sum", value);
        st.add("count", 1.0);
        st.put("average", (Double)st.get("sum") / (Double)st.get("count"));
        return st;
    }

    protected Statistics update(Statistics st, String value) {
        st.add(value, 1.0);
        return st;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statistics getStatistics(String key) {
        Statistics copy;
        Statistics st;
        if (!this.stats.containsKey(key)) {
            return null;
        }
        Statistics statistics = st = this.stats.get(key);
        synchronized (statistics) {
            copy = new Statistics(st);
        }
        return copy;
    }

    @Override
    public Set<Serializable> getTopValues(String key) {
        return new HashSet<Serializable>();
    }

    @Override
    public void reset() throws Exception {
    }
}

