/*
 * Decompiled with CFR 0.152.
 */
package stream.learner;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Processor;
import stream.annotations.Description;
import stream.data.Data;
import stream.learner.PredictionService;

@Description(name="Prediction", group="Data Stream.Mining")
public class Prediction
implements Processor {
    static Logger log = LoggerFactory.getLogger(Prediction.class);
    PredictionService predictionService;

    public void setLearner(PredictionService predService) {
        this.predictionService = predService;
    }

    @Override
    public Data process(Data data) {
        if (this.predictionService != null) {
            try {
                String key = this.predictionService.getName();
                Serializable pred = this.predictionService.predict(data);
                if (!key.startsWith("@prediction")) {
                    key = "@prediction:" + key;
                }
                data.put(key, pred);
                return data;
            }
            catch (Exception e) {
                log.error("Failed to apply prediction: {}", (Object)e.getMessage());
            }
        } else {
            log.error("No PredictionService has been injected!");
        }
        return data;
    }
}

