/*
 * Decompiled with CFR 0.152.
 */
package stream.parser;

import stream.AbstractProcessor;
import stream.annotations.Description;
import stream.annotations.Parameter;
import stream.data.Data;

@Description(group="Streams.Processing.Transformations.Parsers", text="Parses a double value from a string and replaces the attribute string value with the integer object.")
public class ParseInteger
extends AbstractProcessor {
    String[] keys = null;
    Integer defaultValue = null;

    public String[] getKeys() {
        return this.keys;
    }

    @Parameter(required=true, description="The keys/attributes to perform parsing on")
    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public Integer getDefault() {
        return this.defaultValue;
    }

    @Parameter(required=false, defaultValue="0.0", description="The default value to set if parsing fails")
    public void setDefault(Integer defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public Data process(Data data) {
        String[] ks = this.keys;
        if (ks == null) {
            ks = data.keySet().toArray(new String[data.keySet().size()]);
        }
        for (String key : ks) {
            Integer value = this.defaultValue;
            try {
                value = new Integer(data.get(key) + "");
                data.put(key, value);
            }
            catch (Exception e) {
                if (this.defaultValue == null) continue;
                data.put(key, this.defaultValue);
            }
        }
        return data;
    }
}

