/*
 * Decompiled with CFR 0.152.
 */
package stream;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.runtime.ElementHandler;
import stream.runtime.ProcessContainer;
import stream.runtime.StreamRuntime;

public class run {
    static Logger log = LoggerFactory.getLogger(run.class);

    public static void setupOutput() throws Exception {
        if (System.getProperty("container.stdout") != null) {
            System.setOut(new PrintStream(new FileOutputStream(System.getProperty("container.stdout"))));
        }
        if (System.getProperty("container.stderr") != null) {
            System.setOut(new PrintStream(new FileOutputStream(System.getProperty("container.stdout"))));
        }
    }

    public static void main(String[] args) throws Exception {
        URL url;
        run.setupOutput();
        try {
            url = new URL(args[0]);
        }
        catch (Exception e) {
            File f = new File(args[0]);
            url = f.toURI().toURL();
        }
        run.main(url);
    }

    public static void main(URL url) throws Exception {
        run.setupOutput();
        StreamRuntime.setupLogging();
        log.info("Creating process-container from configuration at {}", url);
        ProcessContainer container = new ProcessContainer(url);
        log.info("Starting process-container...");
        container.run();
        log.info("Container finished.");
        System.exit(0);
    }

    public static void main(URL url, Map<String, ElementHandler> elementHandler) throws Exception {
        StreamRuntime.setupLogging();
        log.info("Creating process-container from configuration at {}", url);
        ProcessContainer container = new ProcessContainer(url, elementHandler);
        log.info("Starting process-container...");
        container.run();
        log.info("Container finished.");
        System.exit(0);
    }

    public static void main(String resource) throws Exception {
        log.info("Looking for configuration at resource {} in classpath", (Object)resource);
        run.main(run.class.getResource(resource));
    }

    public static void main(String resource, Map<String, ElementHandler> elementHandler) throws Exception {
        log.info("Looking for configuration at resource {} in classpath", (Object)resource);
        run.main(run.class.getResource(resource), elementHandler);
    }
}

