/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.service.NamingService;
import stream.service.Service;
import stream.service.ServiceInfo;

public class DefaultNamingService
implements NamingService {
    static Logger log = LoggerFactory.getLogger(DefaultNamingService.class);
    final Map<String, Service> services = new HashMap<String, Service>();
    protected final Map<String, NamingService> remoteContainer = new LinkedHashMap<String, NamingService>();
    final String name;

    public DefaultNamingService() {
        this.name = "local";
    }

    public DefaultNamingService(String name) {
        this.name = name;
    }

    protected boolean isLocal(String ref) {
        if (!ref.startsWith("//")) {
            return true;
        }
        return ref.startsWith("//" + this.name + "/");
    }

    public String getNamespace() {
        return this.name;
    }

    protected String getContainerName(String ref) {
        if (!ref.startsWith("//")) {
            return this.name;
        }
        int idx = ref.indexOf("/", 3);
        if (idx < 0) {
            return null;
        }
        return ref.substring(2, idx);
    }

    @Override
    public <T extends Service> T lookup(String ref, Class<T> serviceClass) throws Exception {
        log.debug("Looking up processor by reference '{}'", (Object)ref);
        if (!this.isLocal(ref)) {
            String container = this.getContainerName(ref);
            if (this.remoteContainer.containsKey(container)) {
                log.debug("Delegating lookup to remote-container {} @{}", (Object)container, (Object)this.remoteContainer.get(container));
                return this.remoteContainer.get(container).lookup(ref, serviceClass);
            }
            throw new Exception("Failed to resolve non-local reference '" + ref + "'!");
        }
        if (!ref.startsWith("//" + this.name + "/")) {
            return (T)this.services.get("//" + this.name + "/" + ref);
        }
        return (T)this.services.get(ref);
    }

    @Override
    public void register(String ref, Service p) throws Exception {
        if (!this.isLocal(ref)) {
            throw new Exception("Cannot register remote-references!");
        }
        if (this.services.containsKey(ref)) {
            throw new Exception("A processor is already registered for ID '" + ref + "'!");
        }
        log.debug("Registering new processor {} for key {}", p, (Object)ref);
        if (ref.startsWith("//" + this.name + "/")) {
            this.services.put(ref, p);
        } else {
            this.services.put("//" + this.name + "/" + ref, p);
        }
    }

    @Override
    public void unregister(String ref) throws Exception {
        if (this.services.containsKey(ref)) {
            log.debug("Unregistering processor {}", (Object)ref);
            this.services.remove(ref);
        } else {
            log.debug("No processor registered for reference {}", (Object)ref);
        }
    }

    @Override
    public Map<String, ServiceInfo> list() throws Exception {
        LinkedHashMap<String, ServiceInfo> lst = new LinkedHashMap<String, ServiceInfo>();
        for (String key : this.services.keySet()) {
            lst.put(key, ServiceInfo.createServiceInfo(key, this.services.get(key)));
        }
        return lst;
    }

    @Override
    public void addContainer(String key, NamingService remoteNamingService) throws Exception {
        this.remoteContainer.put(key, remoteNamingService);
    }

    public NamingService getContainer(String key) {
        return this.remoteContainer.get(key);
    }
}

