/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.ProcessContext;
import stream.data.Data;
import stream.data.DataFactory;
import stream.runtime.AbstractProcess;
import stream.util.parser.TimeParser;

public class Monitor
extends AbstractProcess {
    static Logger log = LoggerFactory.getLogger(Monitor.class);
    Long interval = 1000L;
    String intervalString = "1000ms";

    public Monitor() {
        this.setDaemon(true);
    }

    public String getInterval() {
        return this.intervalString;
    }

    public void setInterval(String intervalString) {
        this.intervalString = intervalString;
    }

    @Override
    public Data getNextItem() {
        if (this.lastItem == null) {
            this.lastItem = DataFactory.create();
        } else {
            this.lastItem.clear();
        }
        return this.lastItem;
    }

    @Override
    public void init(ProcessContext context) throws Exception {
        super.init(context);
        try {
            this.interval = TimeParser.parseTime(this.getInterval());
            log.debug("Monitor-interval is {} ms", this.interval);
        }
        catch (Exception e) {
            this.interval = 1000L;
            throw new Exception("Failed to initialize Monitor: " + e.getMessage());
        }
    }

    @Override
    public Data process(Data item) {
        Data data;
        block3: {
            data = super.process(item);
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                if (!this.running) {
                    log.debug("Monitor finished.");
                    return data;
                }
                log.debug("Sleep interrupted.");
                if (!log.isDebugEnabled()) break block3;
                e.printStackTrace();
            }
        }
        return data;
    }
}

