/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableContext {
    static Logger log = LoggerFactory.getLogger(VariableContext.class);
    public static final String VAR_PREFIX = "${";
    public static final String VAR_SUFFIX = "}";
    protected Map<String, String> variables = new HashMap<String, String>();

    public VariableContext() {
        this(new HashMap<String, String>());
    }

    public VariableContext(VariableContext root) {
        this.variables = new HashMap<String, String>();
        if (root.variables != null) {
            this.variables.putAll(root.variables);
        }
    }

    public VariableContext(Map<String, String> variables) {
        this.variables = variables;
    }

    public VariableContext(Properties p) {
        this.variables = new HashMap<String, String>();
        for (Object k : p.keySet()) {
            this.variables.put(k.toString(), p.getProperty(k.toString()));
        }
    }

    public void addVariables(Map<String, String> vars) {
        for (String key : vars.keySet()) {
            this.variables.put(key, vars.get(key));
        }
    }

    public void set(String key, String val) {
        this.variables.put(key, val);
    }

    public String expand(String str, boolean emptyStrings) {
        return this.substitute(str, emptyStrings);
    }

    public String expand(String str) {
        return this.substitute(str, false);
    }

    private String substitute(String str, boolean emptyStrings) {
        String content = str;
        int start = content.indexOf(VAR_PREFIX, 0);
        while (start >= 0) {
            int end = content.indexOf(VAR_SUFFIX, start + 1);
            if (end >= start + 2) {
                String variable = content.substring(start + 2, end);
                log.debug("Found variable: {}", (Object)variable);
                log.trace("   content is: {}", (Object)content);
                int len = variable.length();
                if (this.containsKey(variable)) {
                    String repl = this.get(variable);
                    content = content.substring(0, start) + this.get(variable) + content.substring(end + 1);
                    len = repl.length();
                } else if (emptyStrings) {
                    content = content.substring(0, start) + "" + content.substring(end + 1);
                    len = 0;
                } else {
                    content = content.substring(0, start) + VAR_PREFIX + variable + VAR_SUFFIX + content.substring(end + 1);
                }
                if (end < content.length()) {
                    start = content.indexOf(VAR_PREFIX, start + len);
                    continue;
                }
                start = -1;
                continue;
            }
            start = -1;
        }
        return content;
    }

    protected boolean containsKey(String key) {
        return this.variables.containsKey(key) || System.getProperty(key) != null;
    }

    public String get(String key) {
        String val = this.variables.get(key);
        if (val == null) {
            val = System.getProperty(key);
        }
        return val;
    }
}

