/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.dependencies;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import stream.runtime.dependencies.Dependency;

public class DependencyResolver {
    static Logger log = LoggerFactory.getLogger(DependencyResolver.class);
    final List<String> baseUrls = new ArrayList<String>();
    final Set<URL> classPathUrls = new LinkedHashSet<URL>();
    String localRepo = System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository" + File.separator;
    final Set<Dependency> resolvedDependencies = new LinkedHashSet<Dependency>();
    final Set<String> scopes = new HashSet<String>();

    public DependencyResolver() {
        if (System.getenv("STREAMS_REPOSITORY") != null && !"".equals(System.getenv("STREAMS_REPOSITORY").trim())) {
            this.localRepo = System.getenv("STREAMS_REPOSITORY");
            log.info("Using local repository {}", (Object)this.localRepo);
        }
        this.baseUrls.add(this.localRepo);
        this.baseUrls.add("http://repo.maven.apache.org/maven2/");
        this.scopes.add("compile");
        this.scopes.add("provided");
    }

    public Set<URL> getClasspathURLs() {
        return Collections.unmodifiableSet(this.classPathUrls);
    }

    public Set<Dependency> resolve(Dependency dep) throws Exception {
        HashSet<Dependency> toResolve = new HashSet<Dependency>();
        toResolve.add(dep);
        while (!toResolve.isEmpty()) {
            log.debug("{} dependency left to resolve", toResolve.size());
            Iterator it = toResolve.iterator();
            Dependency cur = (Dependency)it.next();
            it.remove();
            if (this.resolvedDependencies.contains(cur)) continue;
            this.resolvedDependencies.add(cur);
            boolean found = false;
            for (String base : this.baseUrls) {
                try {
                    if (base.startsWith("/")) {
                        base = "file:" + base;
                    }
                    log.info("Checking for {}", cur);
                    Set<Dependency> trans = this.extractDependenciesFromPom(base, cur);
                    for (Dependency t : trans) {
                        if (this.resolvedDependencies.contains(t)) continue;
                        toResolve.add(t);
                    }
                    found = true;
                    break;
                }
                catch (Exception e) {
                    log.error("Failed to resolve dependency {}", cur, (Object)base);
                }
            }
            if (found) continue;
            throw new Exception("Failed to resolve dependency '" + cur + "'!");
        }
        for (Dependency d : this.resolvedDependencies) {
            File file = this.getFileLocation(d);
            this.classPathUrls.add(file.toURI().toURL());
        }
        return this.resolvedDependencies;
    }

    protected File getFileLocation(Dependency d) throws Exception {
        File m2repo = new File(this.localRepo);
        File jar = new File(m2repo.getAbsolutePath() + File.separator + d.getPath());
        File pom = new File(m2repo.getAbsolutePath() + File.separator + d.getPomPath());
        if (jar.isFile() && pom.isFile()) {
            return jar;
        }
        return this.fetch(d, m2repo);
    }

    public File fetch(Dependency d, File repoDir) throws Exception {
        LinkedHashMap<String, String> list = new LinkedHashMap<String, String>();
        list.put("http://repo.maven.apache.org/maven2/" + d.getPomPath(), repoDir.getAbsolutePath() + File.separator + d.getPomPath());
        list.put("http://repo.maven.apache.org/maven2/" + d.getPath(), repoDir.getAbsolutePath() + File.separator + d.getPath());
        File jarFile = new File(repoDir.getAbsolutePath() + File.separator + d.getPath());
        for (String urlString : list.keySet()) {
            File file = new File((String)list.get(urlString));
            if (file.exists()) {
                log.info("File {} already exists.", file);
                continue;
            }
            file.getParentFile().mkdirs();
            URL url = new URL(urlString);
            InputStream in = url.openStream();
            log.info("Downloading artifact {} to {}", (Object)d.getArtifactId(), (Object)file.getAbsolutePath());
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[8192];
            int total = 0;
            int read = in.read(buf);
            while (read > 0) {
                total += read;
                out.write(buf, 0, read);
                read = in.read(buf);
            }
            log.info("{} bytes fetched.", total);
            out.close();
        }
        log.info("Returning jar-file {}", (Object)jarFile.getAbsolutePath());
        return jarFile;
    }

    protected Set<Dependency> extractDependenciesFromPom(String repoUrl, Dependency dep) throws Exception {
        URL pomUrl = new URL(repoUrl + dep.getPomPath());
        log.debug("Using pom @ {}", pomUrl);
        HashSet<Dependency> resolved = new HashSet<Dependency>();
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document pom = db.parse(pomUrl.openStream());
        Element root = pom.getDocumentElement();
        String pomVersion = null;
        NodeList parent = root.getElementsByTagName("parent");
        for (int k = 0; k < parent.getLength(); ++k) {
            Element p = (Element)parent.item(k);
            NodeList nl = p.getChildNodes();
            for (int n = 0; n < nl.getLength(); ++n) {
                Node ch = nl.item(n);
                if (ch.getNodeType() != 1 || !ch.getNodeName().equals("version")) continue;
                pomVersion = ch.getTextContent();
            }
        }
        NodeList list = root.getElementsByTagName("dependency");
        for (int i = 0; i < list.getLength(); ++i) {
            Element el = (Element)list.item(i);
            String groupId = null;
            String artifactId = null;
            String version = null;
            String scope = null;
            NodeList children = el.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node node = children.item(j);
                if (node.getNodeName().equals("groupId")) {
                    groupId = node.getTextContent();
                }
                if (node.getNodeName().equals("artifactId")) {
                    artifactId = node.getTextContent();
                }
                if (node.getNodeName().equals("version")) {
                    version = node.getTextContent();
                }
                if (!node.getNodeName().equals("scope")) continue;
                scope = node.getTextContent();
            }
            if (pomVersion != null && "${pom.version}".equals(version)) {
                version = pomVersion;
            }
            if (groupId == null || artifactId == null || version == null) continue;
            if (version.startsWith("[")) {
                version = version.substring(1);
            }
            if (version.endsWith(",)")) {
                version = version.replace(",)", "");
            }
            if (this.isScopeIncluded(scope)) {
                log.debug("Adding dependency {} with scope {}", (Object)artifactId, scope);
                resolved.add(new Dependency(groupId, artifactId, version));
                continue;
            }
            log.debug("Dependencies with scope '{}' will be ignored.", scope);
        }
        return resolved;
    }

    public boolean isScopeIncluded(String scope) {
        return scope == null || this.scopes.contains(scope.toLowerCase());
    }
}

