/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.dependencies;

import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import stream.runtime.dependencies.DependencyFinder;
import stream.util.URLUtilities;

public class MavenSearchDependencyFinder
implements DependencyFinder {
    static Logger log = LoggerFactory.getLogger(MavenSearchDependencyFinder.class);

    @Override
    public String find(String groupId, String artifactId, String version) throws Exception {
        int sep = 63;
        StringBuffer base = new StringBuffer("http://search.maven.org/solrsearch/select?q=");
        StringBuffer qs = new StringBuffer();
        if (groupId == null) {
            throw new Exception("A groupId needs to be specified!");
        }
        qs.append("g:" + groupId);
        if (artifactId != null) {
            if (qs.length() > 0) {
                qs.append("+");
            }
            qs.append("a:" + artifactId);
        }
        if (version != null) {
            if (qs.length() > 0) {
                qs.append("+");
            }
            qs.append("v:" + version);
        }
        sep = 38;
        base.append(qs.toString());
        base.append("&rows=1");
        base.append("&wt=xml");
        URL url = new URL(base.toString());
        String res = URLUtilities.readContent(url);
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document xml = builder.parse(url.openStream());
        Transformer tf = TransformerFactory.newInstance().newTransformer();
        tf.transform(new DOMSource(xml), new StreamResult(System.out));
        XPath xp = XPathFactory.newInstance().newXPath();
        XPathExpression exp = xp.compile("//result[name=response]");
        NodeList list = (NodeList)exp.evaluate(xml, XPathConstants.NODESET);
        for (int i = 0; i < list.getLength(); ++i) {
            log.info("");
        }
        return res;
    }

    public static void main(String[] args) throws Exception {
        MavenSearchDependencyFinder finder = new MavenSearchDependencyFinder();
        String res = finder.find("org.jwall", "stream-plotter", null);
        log.info("Resolved query to: {}", (Object)res);
    }
}

