/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.monitor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.data.Data;
import stream.service.Service;
import stream.util.SizeOf;

public class MemorySize
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(MemorySize.class);
    String ref = null;
    String prefix = "@memory";

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public Data process(Data input) {
        try {
            Service p = this.context.lookup(this.getRef(), Service.class);
            log.debug("checking memory of processor {}", p);
            Double size = SizeOf.sizeOf(p);
            input.put(this.prefix + ":" + this.getRef(), size);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return input;
    }
}

