/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.rpc;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.runtime.rpc.RMIServiceDelegator;
import stream.runtime.rpc.RemoteEndpoint;
import stream.runtime.setup.ServiceInjection;
import stream.service.Service;

public final class ServiceProxy
extends UnicastRemoteObject
implements RemoteEndpoint {
    private static final long serialVersionUID = -8727610044832533407L;
    static Logger log = LoggerFactory.getLogger(ServiceProxy.class);
    final Service serviceImpl;
    Class<? extends Service>[] serviceInterfaces;
    Map<String, Method> methods = new LinkedHashMap<String, Method>();

    public ServiceProxy(Service service) throws RemoteException {
        log.debug("Creating ServiceProxy for {}", service);
        this.serviceImpl = service;
        for (Class<? extends Service> cl : this.serviceInterfaces = ServiceProxy.getServiceInterfaces(service)) {
            for (Method m : cl.getMethods()) {
                log.debug("Method: '{}'", (Object)m.getName());
                log.debug("    Args: {}", m.getParameterTypes());
                String sig = RMIServiceDelegator.computeSignature(m);
                this.methods.put(sig, m);
                log.debug("Adding (method,signature) with ({},{})", m, (Object)sig);
            }
        }
    }

    @Override
    public Serializable call(String methodName, String signature, List<Serializable> args) throws RemoteException {
        try {
            log.debug("Service implementation is {}", this.serviceImpl);
            Method method = this.methods.get(signature);
            if (method == null) {
                throw new RuntimeException("No method found for that signature!");
            }
            log.trace("Invoking method {} with args: {}", (Object)method.getName(), (Object)args.toArray());
            return (Serializable)method.invoke((Object)this.serviceImpl, args.toArray());
        }
        catch (RuntimeException e) {
            log.error("Runtime error: {}", (Object)e.getMessage());
            throw e;
        }
        catch (InvocationTargetException ie) {
            log.error("Invocation exception: {}", ie.getCause());
            throw new RemoteException(ie.getMessage());
        }
        catch (Exception e) {
            log.error("Exception while calling method: {}", (Object)e.getMessage());
            throw new RemoteException(e.getMessage());
        }
    }

    public Class<? extends Service> getServiceInterface() {
        for (Class<?> clazz : this.serviceImpl.getClass().getInterfaces()) {
            if (clazz == Service.class || !ServiceInjection.isServiceImplementation(clazz)) continue;
            return clazz;
        }
        return null;
    }

    public static Class<? extends Service>[] getServiceInterfaces(Class<?> serviceImpl) {
        ArrayList intfs = new ArrayList();
        for (Class<?> cur = serviceImpl; cur != null; cur = cur.getSuperclass()) {
            log.debug("checking interfaces of class {}", cur);
            for (Class<?> clazz : cur.getInterfaces()) {
                if (clazz != Service.class && ServiceInjection.isServiceImplementation(clazz)) {
                    log.debug("Adding service interface: {}", clazz);
                    intfs.add(clazz);
                    continue;
                }
                log.debug("Not a service interface: {}", clazz);
            }
        }
        return intfs.toArray(new Class[intfs.size()]);
    }

    public static Class<? extends Service>[] getServiceInterfaces(Service p) {
        return ServiceProxy.getServiceInterfaces(p.getClass());
    }
}

