/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import stream.Processor;
import stream.runtime.Monitor;
import stream.runtime.ProcessContainer;
import stream.runtime.setup.ObjectFactory;
import stream.runtime.setup.ProcessElementHandler;
import stream.runtime.setup.ProcessorFactory;

public class MonitorElementHandler
extends ProcessElementHandler {
    static Logger log = LoggerFactory.getLogger(MonitorElementHandler.class);

    public MonitorElementHandler(ObjectFactory objectFactory, ProcessorFactory processorFactory) {
        super(objectFactory, processorFactory);
    }

    @Override
    public String getKey() {
        return "Monitor";
    }

    @Override
    public boolean handlesElement(Element element) {
        return "monitor".equalsIgnoreCase(element.getNodeName());
    }

    @Override
    public void handleElement(ProcessContainer container, Element element) throws Exception {
        Map<String, String> params = this.objectFactory.getAttributes(element);
        String className = "stream.runtime.Monitor";
        if (element.hasAttribute("class")) {
            className = element.getAttribute("class");
            log.info("Creating Monitor instance from custom class '{}'", (Object)className);
        }
        Monitor monitor = (Monitor)this.objectFactory.create(className, params);
        log.debug("Created Monitor object: {}", monitor);
        List<Processor> procs = this.createNestedProcessors(container, element, new HashMap<String, String>());
        for (Processor p : procs) {
            monitor.addProcessor(p);
        }
        container.getProcesses().add(monitor);
    }
}

