/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import stream.runtime.RuntimeClassLoader;
import stream.runtime.VariableContext;
import stream.runtime.setup.ObjectCreator;
import stream.runtime.setup.ParameterInjection;
import stream.runtime.setup.UserSettings;
import stream.utils.FileUtils;

public class ObjectFactory
extends VariableContext {
    static Logger log = LoggerFactory.getLogger(ObjectFactory.class);
    static Map<String, Integer> globalObjectNumbers = new HashMap<String, Integer>();
    static final Map<String, String> classNames = new HashMap<String, String>();
    static final String[] DEFAULT_PACKAGES = new String[]{"", "stream.data.", "stream.data.mapper.", "stream.data.tree.", "stream.filter.", "stream.data.filter.", "stream.data.stats.", "stream.data.vector.", "stream.data.test.", "stream.logic", "stream.flow", "stream.monitor", "stream.statistics", "stream.script"};
    final RuntimeClassLoader classLoader = new RuntimeClassLoader(new URL[0], ObjectFactory.class.getClassLoader());
    final Set<URL> urls = new LinkedHashSet<URL>();
    final List<String> searchPath = new ArrayList<String>();
    static final List<ObjectCreator> objectCreators = new ArrayList<ObjectCreator>();

    protected ObjectFactory() {
        super(new HashMap<String, String>());
        for (String pkg : DEFAULT_PACKAGES) {
            this.addPackage(pkg);
        }
        UserSettings settings = new UserSettings();
        ArrayList<File> files = new ArrayList<File>();
        for (URL url : settings.getLibrarySearchPath()) {
            if (!url.getProtocol().toLowerCase().startsWith("file")) continue;
            files.addAll(FileUtils.findAllFiles(new File(url.getFile())));
        }
        URL[] url = new URL[files.size()];
        log.debug("Extra class paths:");
        int i = 0;
        for (File f : files) {
            if (!f.getName().endsWith(".jar") || f.getName().indexOf("stream-runtime") >= 0) continue;
            try {
                url[i] = f.toURI().toURL();
                this.urls.add(f.toURI().toURL());
                log.debug("   {}", f);
                this.classLoader.addExtraURLs(f.toURI().toURL());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        log.debug("URLs: {}", this.classLoader.getURLs());
    }

    public void addClassPathUrls(Collection<URL> newUrls) {
        log.debug("Adding urls {}", newUrls);
        this.urls.addAll(newUrls);
        log.debug("URLs now are: {}", this.urls);
        Iterator<URL> it = this.urls.iterator();
        while (it.hasNext()) {
            URL url = it.next();
            if (url.toString().indexOf("stream-runtime") >= 0) {
                log.debug("Removing referenced URL {}", url);
                it.remove();
                continue;
            }
            this.classLoader.addExtraURLs(url);
        }
        log.debug("URLClassLoader.getURLs(): {}", this.classLoader.getURLs());
    }

    public void addPackage(String pkg) {
        String name = pkg;
        if (!name.endsWith(".")) {
            name = name + ".";
        }
        if (!this.searchPath.contains(name)) {
            this.searchPath.add(0, name);
        } else {
            log.warn("Package {} already in search-path!", (Object)pkg);
        }
    }

    public List<String> getSearchPaths() {
        return this.searchPath;
    }

    public static void register(String name, Class<?> clazz) {
        classNames.put(name.toLowerCase(), clazz.getName());
    }

    public static void registerObjectCreator(ObjectCreator creator) {
        objectCreators.add(creator);
    }

    public static ObjectFactory newInstance() {
        return new ObjectFactory();
    }

    public static synchronized String getNextIdentifier(String obj) {
        Integer cur = globalObjectNumbers.get(obj);
        if (cur == null) {
            cur = new Integer(0);
        }
        globalObjectNumbers.put(obj, cur + 1);
        return obj + cur;
    }

    public Object create(Element node) throws Exception {
        Map<String, String> params = this.getAttributes(node);
        log.debug("Creating object '{}' with attributes: {}", (Object)node.getNodeName(), params);
        String name = node.getNodeName();
        for (ObjectCreator creator : objectCreators) {
            if (!name.startsWith(creator.getNamespace())) continue;
            return creator.create(name, params);
        }
        Object obj = this.create(this.findClassForElement(node), params);
        return obj;
    }

    public Object create(String className, Map<String, String> parameter) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.putAll(this.variables);
        params.putAll(parameter);
        log.debug("Parameters for new class: {}", params);
        log.debug("object-factory.variables: {}", this.variables);
        HashMap<String, String> p = new HashMap<String, String>();
        for (String key : parameter.keySet()) {
            String expanded;
            String orig;
            if (parameter.get(key).indexOf("%{container") >= 0) {
                orig = parameter.get(key);
                expanded = this.expand(orig);
                p.put(key, expanded);
                log.debug("Expanded {} to {}", (Object)orig, (Object)expanded);
                continue;
            }
            orig = parameter.get(key);
            expanded = this.expand(orig);
            log.debug("Expanded {} to {}", (Object)orig, (Object)expanded);
            p.put(key, expanded);
        }
        Object object = null;
        for (ObjectCreator creator : objectCreators) {
            if (!className.startsWith(creator.getNamespace())) continue;
            log.info("Found object-creator {} for class {}", creator, (Object)className);
            object = creator.create(className, params);
            return object;
        }
        Class<?> clazz = Class.forName(className, false, this.classLoader);
        object = clazz.newInstance();
        log.debug("Injecting parameters: {}", p);
        ParameterInjection.inject(object, p, this);
        return object;
    }

    public Map<String, String> getAttributes(Node node) {
        Element element;
        String text;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        NamedNodeMap att = node.getAttributes();
        for (int i = 0; i < att.getLength(); ++i) {
            Node attr = att.item(i);
            String value = this.expand(attr.getNodeValue(), false);
            map.put(attr.getNodeName(), value);
        }
        if (node.getNodeType() == 1 && (text = (element = (Element)node).getTextContent()) != null && !"".equals(text.trim())) {
            map.put("__EMBEDDED_CONTENT__", this.expand(text));
        }
        return map;
    }

    public String findClassForElement(Element node) throws Exception {
        if (node.getAttribute("class") != null && !"".equals(node.getAttribute("class"))) {
            return node.getAttribute("class");
        }
        try {
            this.classLoader.loadClass(node.getNodeName());
            log.debug("Found direct class-match: {}", (Object)node.getNodeName());
            URL doc = this.findDocumentation(node.getNodeName());
            if (doc == null) {
                log.warn("No documentation provided for class '{}'!", (Object)node.getNodeName());
            }
            return node.getNodeName();
        }
        catch (Exception e) {
            for (String prefix : this.searchPath) {
                String cn = prefix + node.getNodeName();
                try {
                    while (cn.startsWith(".")) {
                        cn = cn.substring(1);
                    }
                    log.debug("Checking for class {}", (Object)cn);
                    Class<?> clazz = this.classLoader.loadClass(cn);
                    log.debug("Auto-detected class {} for node {}", clazz, (Object)node.getNodeName());
                    URL doc = this.findDocumentation(clazz.getName());
                    if (doc == null) {
                        log.warn("No documentation provided for class '{}'!", (Object)clazz.getName());
                    }
                    return clazz.getName();
                }
                catch (Exception e2) {
                    log.debug("No class '{}' found", (Object)cn);
                }
            }
            throw new Exception("Failed to determine class for node '" + node.getNodeName() + "'!");
        }
    }

    public URL findDocumentation(String className) {
        String docResource = "/" + className.replace('.', '/') + ".md";
        log.trace("Doc resource for '{}' is '{}'", (Object)className, (Object)docResource);
        URL url = this.classLoader.getResource(docResource);
        return url;
    }
}

