/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import stream.runtime.ProcessContainer;
import stream.runtime.VariableContext;
import stream.runtime.setup.DocumentHandler;

public class PropertiesHandler
extends VariableContext
implements DocumentHandler {
    static Logger log = LoggerFactory.getLogger(PropertiesHandler.class);

    @Override
    public void handle(ProcessContainer container, Document doc) throws Exception {
        this.findPropertiesElements(container, doc);
        this.findPropertyElements(container, doc);
        this.addSystemProperties(container);
    }

    private void findPropertiesElements(ProcessContainer container, Document doc) {
        NodeList list = doc.getElementsByTagName("properties");
        for (int i = 0; i < list.getLength(); ++i) {
            Element prop = (Element)list.item(i);
            NodeList children = prop.getChildNodes();
            for (int k = 0; k < children.getLength(); ++k) {
                Node ch = children.item(k);
                if (ch.getNodeType() != 1) continue;
                String key = ch.getNodeName();
                String value = ch.getTextContent();
                container.getContext().setProperty(key, value);
                this.set(key, value);
            }
        }
    }

    private void findPropertyElements(ProcessContainer container, Document doc) {
        NodeList ch = doc.getElementsByTagName("property");
        for (int i = 0; i < ch.getLength(); ++i) {
            Element el;
            Node child = ch.item(i);
            if (!(child instanceof Element) || !(el = (Element)child).getNodeName().equalsIgnoreCase("property")) continue;
            String key = el.getAttribute("name");
            String value = el.getAttribute("value");
            if (key == null || "".equals(key.trim()) || value == null || "".equals(value.trim())) continue;
            String k = key.trim();
            String v = value.trim();
            log.info("Setting property {} = {}", (Object)k, (Object)v);
            container.getContext().setProperty(k, v);
            this.set(k, v);
        }
    }

    private void addSystemProperties(ProcessContainer container) {
        for (Object key : System.getProperties().keySet()) {
            container.getContext().setProperty(key.toString(), System.getProperty(key.toString()));
            this.set(key.toString(), System.getProperty(key.toString()));
        }
    }
}

