/*
 * Decompiled with CFR 0.152.
 */
package stream.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.annotations.BodyContent;
import stream.annotations.Parameter;
import stream.data.Data;

public abstract class Script
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(Script.class);
    static final ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    protected BodyContent embedded = null;
    protected ScriptEngine scriptEngine;
    protected File file;
    protected transient String theScript = null;

    public Script(ScriptEngine engine) {
        if (engine == null) {
            throw new RuntimeException("No ScriptEngine found!");
        }
        this.scriptEngine = engine;
    }

    protected Script() {
    }

    public File getFile() {
        return this.file;
    }

    @Parameter(required=false)
    public void setFile(File file) {
        this.file = file;
    }

    public BodyContent getScript() {
        return this.embedded;
    }

    @Parameter(required=false)
    public void setScript(BodyContent embedded) {
        this.embedded = embedded;
    }

    @Override
    public Data process(Data data) {
        try {
            String script = this.loadScript();
            log.info("Script loaded is:\n{}", (Object)script);
            ScriptContext ctx = this.scriptEngine.getContext();
            ctx.setAttribute("data", data, 100);
            this.scriptEngine.put("data", data);
            log.info("Evaluating script...");
            this.scriptEngine.eval(script, ctx);
        }
        catch (Exception e) {
            log.error("Failed to execute script: {}", (Object)e.getMessage());
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new RuntimeException("Script execution error: " + e.getMessage());
        }
        log.info("Returning data: {}", data);
        return data;
    }

    protected String loadScript() throws Exception {
        if (this.theScript == null) {
            if (this.embedded != null) {
                log.info("Using embedded content...");
                this.theScript = this.embedded.getContent();
                return this.theScript;
            }
            if (this.file != null) {
                log.debug("Reading script from file {}", this.file);
                this.theScript = this.loadScript(new FileInputStream(this.file));
                return this.theScript;
            }
        }
        return this.theScript;
    }

    protected String loadScript(InputStream in) throws Exception {
        log.debug("Loading script from input-stream {}", in);
        StringBuffer s = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = reader.readLine();
        while (line != null) {
            s.append(line + "\n");
            log.debug("Appending line: {}", (Object)line);
            line = reader.readLine();
        }
        reader.close();
        return s.toString();
    }
}

