/*
 * Decompiled with CFR 0.152.
 */
package stream.service;

import java.io.Serializable;
import java.util.ArrayList;
import stream.service.Service;

public final class ServiceInfo
implements Serializable {
    private static final long serialVersionUID = -6189552556440798733L;
    final String name;
    final Class<? extends Service>[] services;

    private ServiceInfo(String name, Class<? extends Service>[] services) {
        this.name = name;
        this.services = services;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends Service>[] getServices() {
        return this.services;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("ServiceInfo[" + this.name + "]{");
        for (int i = 0; i < this.services.length; ++i) {
            s.append(this.services[i]);
            if (i + 1 >= this.services.length) continue;
            s.append(",");
        }
        s.append("}");
        return s.toString();
    }

    public static Class<? extends Service>[] getServiceInterfaces(Class<?> serviceImpl) {
        ArrayList intfs = new ArrayList();
        for (Class<?> cur = serviceImpl; cur != null; cur = cur.getSuperclass()) {
            for (Class<?> clazz : cur.getInterfaces()) {
                if (clazz == Service.class || !ServiceInfo.isServiceImplementation(clazz)) continue;
                intfs.add(clazz);
            }
        }
        return intfs.toArray(new Class[intfs.size()]);
    }

    public static Class<? extends Service>[] getServiceInterfaces(Service p) {
        return ServiceInfo.getServiceInterfaces(p.getClass());
    }

    public static ServiceInfo createServiceInfo(String name, Service service) throws Exception {
        return new ServiceInfo(name, ServiceInfo.getServiceInterfaces(service));
    }

    public static ServiceInfo createServiceInfo(String name, Class<? extends Service> serviceClass) {
        return new ServiceInfo(name, ServiceInfo.getServiceInterfaces(serviceClass));
    }

    public static boolean isServiceImplementation(Class<?> clazz) {
        if (clazz == Service.class) {
            return true;
        }
        if (clazz.isArray()) {
            return false;
        }
        for (Class<?> intf : clazz.getInterfaces()) {
            if (!intf.equals(Service.class) && intf != Service.class) continue;
            return true;
        }
        return false;
    }
}

