/*
 * Decompiled with CFR 0.152.
 */
package stream.statistics;

import stream.annotations.Description;
import stream.data.Data;
import stream.statistics.Sum;

@Description(group="Data Stream.Processing.Statistics", text="Continuously determines the average value of numeric attributes")
public class Average
extends Sum {
    Double count = 0.0;

    @Override
    public void updateStatistics(Data item) {
        if (this.keys == null) {
            return;
        }
        this.count = this.count + 1.0;
        for (String key : this.keys) {
            Double val = null;
            try {
                val = new Double(item.get(key) + "");
            }
            catch (Exception e) {
                val = null;
            }
            if (val == null) continue;
            this.statistics.add(key, val);
            if (this.prefix != null) {
                item.put(this.prefix + key, (Double)this.statistics.get(key) / this.count);
                continue;
            }
            item.put(key, (Double)this.statistics.get(key) / this.count);
        }
    }
}

